/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.config.DefaultRetryPolicy;
import org.acra.config.RetryPolicy;
import org.acra.data.CrashReportData;
import org.acra.file.CrashReportPersister;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;
import org.acra.util.IOUtils;
import org.acra.util.InstanceCreator;
import org.json.JSONException;

final class ReportDistributor {
    private final Context context;
    private final CoreConfiguration config;
    private final List<ReportSender> reportSenders;

    ReportDistributor(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull List<ReportSender> reportSenders) {
        this.context = context;
        this.config = config;
        this.reportSenders = reportSenders;
    }

    public boolean distribute(@NonNull File reportFile) {
        ACRA.log.i(ACRA.LOG_TAG, "Sending report " + reportFile);
        try {
            CrashReportPersister persister = new CrashReportPersister();
            CrashReportData previousCrashReport = persister.load(reportFile);
            this.sendCrashReport(previousCrashReport);
            IOUtils.deleteFile(reportFile);
            return true;
        }
        catch (RuntimeException e) {
            ACRA.log.e(ACRA.LOG_TAG, "Failed to send crash reports for " + reportFile, e);
            IOUtils.deleteFile(reportFile);
        }
        catch (IOException e) {
            ACRA.log.e(ACRA.LOG_TAG, "Failed to load crash report for " + reportFile, e);
            IOUtils.deleteFile(reportFile);
        }
        catch (JSONException e) {
            ACRA.log.e(ACRA.LOG_TAG, "Failed to load crash report for " + reportFile, e);
            IOUtils.deleteFile(reportFile);
        }
        catch (ReportSenderException e) {
            ACRA.log.e(ACRA.LOG_TAG, "Failed to send crash report for " + reportFile, e);
        }
        return false;
    }

    private void sendCrashReport(@NonNull CrashReportData errorContent) throws ReportSenderException {
        if (!this.isDebuggable() || this.config.sendReportsInDevMode()) {
            LinkedList<RetryPolicy.FailedSender> failedSenders = new LinkedList<RetryPolicy.FailedSender>();
            for (ReportSender sender : this.reportSenders) {
                try {
                    if (ACRA.DEV_LOGGING) {
                        ACRA.log.d(ACRA.LOG_TAG, "Sending report using " + sender.getClass().getName());
                    }
                    sender.send(this.context, errorContent);
                    if (!ACRA.DEV_LOGGING) continue;
                    ACRA.log.d(ACRA.LOG_TAG, "Sent report using " + sender.getClass().getName());
                }
                catch (ReportSenderException e) {
                    failedSenders.add(new RetryPolicy.FailedSender(sender, e));
                }
            }
            InstanceCreator instanceCreator = new InstanceCreator();
            if (failedSenders.isEmpty()) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "Report was sent by all senders");
                }
            } else {
                if (instanceCreator.create(this.config.retryPolicyClass(), DefaultRetryPolicy::new).shouldRetrySend(this.reportSenders, failedSenders)) {
                    ReportSenderException firstFailure = ((RetryPolicy.FailedSender)failedSenders.get(0)).getException();
                    throw new ReportSenderException("Policy marked this task as incomplete. ACRA will try to send this report again.", firstFailure);
                }
                StringBuilder builder = new StringBuilder("ReportSenders of classes [");
                for (RetryPolicy.FailedSender failedSender : failedSenders) {
                    builder.append(failedSender.getSender().getClass().getName());
                    builder.append(", ");
                }
                builder.append("] failed, but Policy marked this task as complete. ACRA will not send this report again.");
                ACRA.log.w(ACRA.LOG_TAG, builder.toString());
            }
        }
    }

    private boolean isDebuggable() {
        PackageManager pm = this.context.getPackageManager();
        try {
            return (pm.getApplicationInfo((String)this.context.getPackageName(), (int)0).flags & 2) > 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}

