/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.sender.NullSender;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderFactory;

public final class DefaultReportSenderFactory
implements ReportSenderFactory {
    @Override
    @NonNull
    public ReportSender create(@NonNull Context context, @NonNull CoreConfiguration config) {
        ArrayList<ReportSenderFactory> factoryList = new ArrayList<ReportSenderFactory>();
        Iterator<ReportSenderFactory> iterator = ServiceLoader.load(ReportSenderFactory.class, this.getClass().getClassLoader()).iterator();
        while (iterator.hasNext()) {
            try {
                ReportSenderFactory reportSenderFactory = iterator.next();
                if (reportSenderFactory.enabled(config)) {
                    factoryList.add(reportSenderFactory);
                    continue;
                }
                if (!ACRA.DEV_LOGGING) continue;
                ACRA.log.d(ACRA.LOG_TAG, "Ignoring disabled ReportSenderFactory of type " + reportSenderFactory.getClass().getSimpleName());
            }
            catch (ServiceConfigurationError e) {
                ACRA.log.e(ACRA.LOG_TAG, "Unable to load ReportSenderFactory", e);
            }
        }
        if (factoryList.size() == 1) {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Autodiscovered ReportSenderFactory of type " + ((ReportSenderFactory)factoryList.get(0)).getClass().getSimpleName());
            }
            return ((ReportSenderFactory)factoryList.get(0)).create(context, config);
        }
        if (factoryList.size() > 1) {
            ACRA.log.w(ACRA.LOG_TAG, "Multiple ReportSenderFactories were discovered - please configure those you want to use. No reports will be sent");
        } else {
            ACRA.log.w(ACRA.LOG_TAG, "No ReportSenderFactories were discovered. No reports will be sent");
        }
        return new NullSender();
    }
}

