/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.support.annotation.NonNull;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.Collector;
import org.acra.collector.CollectorException;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;

abstract class BaseReportFieldCollector
implements Collector {
    private final ReportField[] reportFields;

    BaseReportFieldCollector(@NonNull ReportField firstField, ReportField ... reportFields) {
        this.reportFields = new ReportField[reportFields.length + 1];
        this.reportFields[0] = firstField;
        if (reportFields.length > 0) {
            System.arraycopy(reportFields, 0, this.reportFields, 1, reportFields.length);
        }
    }

    boolean shouldCollect(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportField collect, @NonNull ReportBuilder reportBuilder) {
        return config.reportContent().contains((Object)collect);
    }

    @Override
    public final void collect(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) throws CollectorException {
        for (ReportField field : this.reportFields) {
            try {
                if (!this.shouldCollect(context, config, field, reportBuilder)) continue;
                this.collect(field, context, config, reportBuilder, target);
            }
            catch (Throwable t) {
                target.put(field, (String)null);
                throw new CollectorException("Error while retrieving " + field.name() + " data:" + t.getMessage(), t);
            }
        }
    }

    abstract void collect(@NonNull ReportField var1, @NonNull Context var2, @NonNull CoreConfiguration var3, @NonNull ReportBuilder var4, @NonNull CrashReportData var5) throws Exception;
}

