/*
 * Decompiled with CFR 0.152.
 */
package org.acra.builder;

import android.content.Context;
import android.os.Debug;
import android.os.Looper;
import android.os.StrictMode;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.acra.ACRA;
import org.acra.ACRAConstants;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.config.CoreConfiguration;
import org.acra.config.ReportingAdministrator;
import org.acra.data.CrashReportData;
import org.acra.data.CrashReportDataFactory;
import org.acra.file.CrashReportPersister;
import org.acra.file.ReportLocator;
import org.acra.interaction.ReportInteractionExecutor;
import org.acra.sender.SenderServiceStarter;
import org.acra.util.ProcessFinisher;
import org.acra.util.ToastSender;

public class ReportExecutor {
    private final Context context;
    private final CoreConfiguration config;
    private final CrashReportDataFactory crashReportDataFactory;
    private final List<ReportingAdministrator> reportingAdministrators;
    private final Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private final ProcessFinisher processFinisher;
    private boolean enabled = false;

    public ReportExecutor(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull CrashReportDataFactory crashReportDataFactory, @Nullable Thread.UncaughtExceptionHandler defaultExceptionHandler, @NonNull ProcessFinisher processFinisher) {
        this.context = context;
        this.config = config;
        this.crashReportDataFactory = crashReportDataFactory;
        this.defaultExceptionHandler = defaultExceptionHandler;
        this.processFinisher = processFinisher;
        this.reportingAdministrators = new ArrayList<ReportingAdministrator>();
        Iterator<ReportingAdministrator> iterator = ServiceLoader.load(ReportingAdministrator.class, this.getClass().getClassLoader()).iterator();
        while (iterator.hasNext()) {
            try {
                ReportingAdministrator reportingAdministrator = iterator.next();
                if (!reportingAdministrator.enabled(config)) continue;
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "Loaded ReportingAdministrator of class " + reportingAdministrator.getClass().getName());
                }
                this.reportingAdministrators.add(reportingAdministrator);
            }
            catch (ServiceConfigurationError e) {
                ACRA.log.e(ACRA.LOG_TAG, "Unable to load ReportingAdministrator", e);
            }
        }
    }

    public void handReportToDefaultExceptionHandler(@Nullable Thread t, @NonNull Throwable e) {
        if (this.defaultExceptionHandler != null) {
            ACRA.log.i(ACRA.LOG_TAG, "ACRA is disabled for " + this.context.getPackageName() + " - forwarding uncaught Exception on to default ExceptionHandler");
            this.defaultExceptionHandler.uncaughtException(t, e);
        } else {
            ACRA.log.e(ACRA.LOG_TAG, "ACRA is disabled for " + this.context.getPackageName() + " - no default ExceptionHandler");
            ACRA.log.e(ACRA.LOG_TAG, "ACRA caught a " + e.getClass().getSimpleName() + " for " + this.context.getPackageName(), e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void execute(@NonNull ReportBuilder reportBuilder) {
        CrashReportData crashReportData;
        if (!this.enabled) {
            ACRA.log.v(ACRA.LOG_TAG, "ACRA is disabled. Report not sent.");
            return;
        }
        ReportingAdministrator blockingAdministrator = null;
        for (ReportingAdministrator reportingAdministrator : this.reportingAdministrators) {
            try {
                if (reportingAdministrator.shouldStartCollecting(this.context, this.config, reportBuilder)) continue;
                blockingAdministrator = reportingAdministrator;
            }
            catch (Throwable t) {
                ACRA.log.w(ACRA.LOG_TAG, "ReportingAdministrator " + reportingAdministrator.getClass().getName() + " threw exception", t);
            }
        }
        if (blockingAdministrator == null) {
            crashReportData = this.crashReportDataFactory.createCrashData(reportBuilder);
            for (ReportingAdministrator administrator : this.reportingAdministrators) {
                try {
                    if (administrator.shouldSendReport(this.context, this.config, crashReportData)) continue;
                    blockingAdministrator = administrator;
                }
                catch (Throwable t) {
                    ACRA.log.w(ACRA.LOG_TAG, "ReportingAdministrator " + administrator.getClass().getName() + " threw exception", t);
                }
            }
        } else {
            crashReportData = null;
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Not collecting crash report because of ReportingAdministrator " + blockingAdministrator.getClass().getName());
            }
        }
        if (reportBuilder.isEndApplication()) {
            this.processFinisher.finishLastActivity(reportBuilder.getUncaughtExceptionThread());
        }
        if (blockingAdministrator == null) {
            StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskWrites();
            File reportFile = this.getReportFileName(crashReportData);
            this.saveCrashReportFile(reportFile, crashReportData);
            ReportInteractionExecutor executor = new ReportInteractionExecutor(this.context, this.config);
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            if (reportBuilder.isSendSilently()) {
                this.startSendingReports(executor.hasInteractions());
            } else if (executor.performInteractions(reportFile)) {
                this.startSendingReports(false);
            }
        } else {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Not sending crash report because of ReportingAdministrator " + blockingAdministrator.getClass().getName());
            }
            try {
                blockingAdministrator.notifyReportDropped(this.context, this.config);
            }
            catch (Throwable throwable) {
                ACRA.log.w(ACRA.LOG_TAG, "ReportingAdministrator " + blockingAdministrator.getClass().getName() + " threw exeption", throwable);
            }
        }
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Wait for Interactions + worker ended. Kill Application ? " + reportBuilder.isEndApplication());
        }
        if (reportBuilder.isEndApplication()) {
            boolean bl;
            boolean bl2 = true;
            for (ReportingAdministrator administrator : this.reportingAdministrators) {
                try {
                    if (administrator.shouldKillApplication(this.context, this.config, reportBuilder, crashReportData)) continue;
                    bl = false;
                }
                catch (Throwable t) {
                    ACRA.log.w(ACRA.LOG_TAG, "ReportingAdministrator " + administrator.getClass().getName() + " threw exception", t);
                }
            }
            if (bl) {
                if (Debug.isDebuggerConnected()) {
                    String warning = "Warning: Acra may behave differently with a debugger attached";
                    new Thread(() -> {
                        Looper.prepare();
                        ToastSender.sendToast(this.context, "Warning: Acra may behave differently with a debugger attached", 1);
                        Looper.loop();
                    }).start();
                    ACRA.log.w(ACRA.LOG_TAG, "Warning: Acra may behave differently with a debugger attached");
                } else {
                    this.endApplication(reportBuilder.getUncaughtExceptionThread(), reportBuilder.getException());
                }
            }
        }
    }

    private void endApplication(@Nullable Thread uncaughtExceptionThread, Throwable th) {
        boolean handlingUncaughtException;
        boolean letDefaultHandlerEndApplication = this.config.alsoReportToAndroidFramework();
        boolean bl = handlingUncaughtException = uncaughtExceptionThread != null;
        if (handlingUncaughtException && letDefaultHandlerEndApplication && this.defaultExceptionHandler != null) {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Handing Exception on to default ExceptionHandler");
            }
            this.defaultExceptionHandler.uncaughtException(uncaughtExceptionThread, th);
        } else {
            this.processFinisher.endApplication();
        }
    }

    private void startSendingReports(boolean onlySendSilentReports) {
        if (this.enabled) {
            SenderServiceStarter starter = new SenderServiceStarter(this.context, this.config);
            starter.startService(onlySendSilentReports, true);
        } else {
            ACRA.log.w(ACRA.LOG_TAG, "Would be sending reports, but ACRA is disabled");
        }
    }

    @NonNull
    private File getReportFileName(@NonNull CrashReportData crashData) {
        String timestamp = crashData.getString(ReportField.USER_CRASH_DATE);
        String isSilent = crashData.getString(ReportField.IS_SILENT);
        String fileName = timestamp + (isSilent != null ? ACRAConstants.SILENT_SUFFIX : "") + ".stacktrace";
        ReportLocator reportLocator = new ReportLocator(this.context);
        return new File(reportLocator.getUnapprovedFolder(), fileName);
    }

    private void saveCrashReportFile(@NonNull File file, @NonNull CrashReportData crashData) {
        try {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Writing crash report file " + file);
            }
            CrashReportPersister persister = new CrashReportPersister();
            persister.store(crashData, file);
        }
        catch (Exception e) {
            ACRA.log.e(ACRA.LOG_TAG, "An error occurred while writing the report file...", e);
        }
    }
}

