/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;
import org.acra.ACRA;
import org.acra.builder.LastActivityManager;
import org.acra.config.CoreConfiguration;
import org.acra.sender.SenderService;
import org.acra.util.SystemServices;

public final class ProcessFinisher {
    private final Context context;
    private final CoreConfiguration config;
    private final LastActivityManager lastActivityManager;

    public ProcessFinisher(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull LastActivityManager lastActivityManager) {
        this.context = context;
        this.config = config;
        this.lastActivityManager = lastActivityManager;
    }

    public void endApplication() {
        this.stopServices();
        this.killProcessAndExit();
    }

    public void finishLastActivity(@Nullable Thread uncaughtExceptionThread) {
        Activity lastActivity = this.lastActivityManager.getLastActivity();
        if (lastActivity != null) {
            boolean isMainThread;
            boolean bl = isMainThread = uncaughtExceptionThread == lastActivity.getMainLooper().getThread();
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Finishing the last Activity prior to killing the Process");
            }
            Runnable finisher = () -> {
                lastActivity.finish();
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "Finished " + lastActivity.getClass());
                }
            };
            if (isMainThread) {
                finisher.run();
            } else {
                lastActivity.runOnUiThread(finisher);
            }
            if (!isMainThread) {
                this.lastActivityManager.waitForActivityStop(100);
            }
            this.lastActivityManager.clearLastActivity();
        }
    }

    private void stopServices() {
        if (this.config.stopServicesOnCrash()) {
            try {
                ActivityManager activityManager = SystemServices.getActivityManager(this.context);
                List runningServices = activityManager.getRunningServices(Integer.MAX_VALUE);
                int pid = Process.myPid();
                for (ActivityManager.RunningServiceInfo serviceInfo : runningServices) {
                    if (serviceInfo.pid != pid || SenderService.class.getName().equals(serviceInfo.service.getClassName())) continue;
                    try {
                        Intent intent = new Intent();
                        intent.setComponent(serviceInfo.service);
                        this.context.stopService(intent);
                    }
                    catch (SecurityException e) {
                        if (!ACRA.DEV_LOGGING) continue;
                        ACRA.log.d(ACRA.LOG_TAG, "Unable to stop Service " + serviceInfo.service.getClassName() + ". Permission denied");
                    }
                }
            }
            catch (SystemServices.ServiceNotReachedException e) {
                ACRA.log.e(ACRA.LOG_TAG, "Unable to stop services", e);
            }
        }
    }

    private void killProcessAndExit() {
        Process.killProcess((int)Process.myPid());
        System.exit(10);
    }
}

