/*
 * Decompiled with CFR 0.152.
 */
package org.acra.reporter;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.acra.ACRA;
import org.acra.ErrorReporter;
import org.acra.builder.LastActivityManager;
import org.acra.builder.ReportBuilder;
import org.acra.builder.ReportExecutor;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportDataFactory;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.util.InstanceCreator;
import org.acra.util.ProcessFinisher;

public class ErrorReporterImpl
implements Thread.UncaughtExceptionHandler,
SharedPreferences.OnSharedPreferenceChangeListener,
ErrorReporter {
    private final boolean supportedAndroidVersion;
    private final Application context;
    private final ReportExecutor reportExecutor;
    private final Map<String, String> customData = new HashMap<String, String>();

    public ErrorReporterImpl(@NonNull Application context, @NonNull CoreConfiguration config, boolean enabled, boolean supportedAndroidVersion) {
        this.context = context;
        this.supportedAndroidVersion = supportedAndroidVersion;
        CrashReportDataFactory crashReportDataFactory = new CrashReportDataFactory((Context)context, config);
        crashReportDataFactory.collectStartUp();
        Thread.UncaughtExceptionHandler defaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        LastActivityManager lastActivityManager = new LastActivityManager(this.context);
        InstanceCreator instanceCreator = new InstanceCreator();
        ProcessFinisher processFinisher = new ProcessFinisher((Context)context, config, lastActivityManager);
        this.reportExecutor = new ReportExecutor((Context)context, config, crashReportDataFactory, defaultExceptionHandler, processFinisher);
        this.reportExecutor.setEnabled(enabled);
    }

    @Override
    public String putCustomData(@NonNull String key, @Nullable String value) {
        return this.customData.put(key, value);
    }

    @Override
    @Nullable
    public String removeCustomData(@NonNull String key) {
        return this.customData.remove(key);
    }

    @Override
    public void clearCustomData() {
        this.customData.clear();
    }

    @Override
    @Nullable
    public String getCustomData(@NonNull String key) {
        return this.customData.get(key);
    }

    @Override
    public void uncaughtException(@Nullable Thread t, @NonNull Throwable e) {
        if (!this.reportExecutor.isEnabled()) {
            this.reportExecutor.handReportToDefaultExceptionHandler(t, e);
            return;
        }
        try {
            ACRA.log.e(ACRA.LOG_TAG, "ACRA caught a " + e.getClass().getSimpleName() + " for " + this.context.getPackageName(), e);
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Building report");
            }
            new ReportBuilder().uncaughtExceptionThread(t).exception(e).customData(this.customData).endApplication().build(this.reportExecutor);
        }
        catch (Throwable fatality) {
            ACRA.log.e(ACRA.LOG_TAG, "ACRA failed to capture the error - handing off to native error reporter", fatality);
            this.reportExecutor.handReportToDefaultExceptionHandler(t, e);
        }
    }

    @Override
    public void handleSilentException(@Nullable Throwable e) {
        new ReportBuilder().exception(e).customData(this.customData).sendSilently().build(this.reportExecutor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.supportedAndroidVersion) {
            ACRA.log.i(ACRA.LOG_TAG, "ACRA is " + (enabled ? "enabled" : "disabled") + " for " + this.context.getPackageName());
            this.reportExecutor.setEnabled(enabled);
        } else {
            ACRA.log.w(ACRA.LOG_TAG, "ACRA 4.7.0+ requires Froyo or greater. ACRA is disabled and will NOT catch crashes or send messages.");
        }
    }

    @Override
    public void handleException(@Nullable Throwable e, boolean endApplication) {
        ReportBuilder builder = new ReportBuilder();
        builder.exception(e).customData(this.customData);
        if (endApplication) {
            builder.endApplication();
        }
        builder.build(this.reportExecutor);
    }

    @Override
    public void handleException(@Nullable Throwable e) {
        this.handleException(e, false);
    }

    public void onSharedPreferenceChanged(@NonNull SharedPreferences sharedPreferences, @Nullable String key) {
        if ("acra.disable".equals(key) || "acra.enable".equals(key)) {
            this.setEnabled(SharedPreferencesFactory.shouldEnableACRA(sharedPreferences));
        }
    }
}

