/*
 * Decompiled with CFR 0.152.
 */
package org.acra.data;

import android.content.Context;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.acra.ACRA;
import org.acra.builder.ReportBuilder;
import org.acra.collector.ApplicationStartupCollector;
import org.acra.collector.Collector;
import org.acra.collector.CollectorException;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;

public final class CrashReportDataFactory {
    private final Context context;
    private final CoreConfiguration config;
    private final List<Collector> collectors;

    public CrashReportDataFactory(@NonNull Context context, @NonNull CoreConfiguration config) {
        this.context = context;
        this.config = config;
        this.collectors = new ArrayList<Collector>();
        Iterator<Collector> iterator = ServiceLoader.load(Collector.class).iterator();
        while (iterator.hasNext()) {
            try {
                Collector collector = iterator.next();
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "Loaded collector of class " + collector.getClass().getName());
                }
                this.collectors.add(collector);
            }
            catch (ServiceConfigurationError e) {
                ACRA.log.e(ACRA.LOG_TAG, "Unable to load collector", e);
            }
        }
        Collections.sort(this.collectors, (c1, c2) -> {
            Collector.Order o2;
            Collector.Order o1;
            try {
                o1 = c1.getOrder();
            }
            catch (Throwable t) {
                o1 = Collector.Order.NORMAL;
            }
            try {
                o2 = c2.getOrder();
            }
            catch (Throwable t) {
                o2 = Collector.Order.NORMAL;
            }
            return o1.ordinal() - o2.ordinal();
        });
    }

    @NonNull
    public CrashReportData createCrashData(@NonNull ReportBuilder builder) {
        ExecutorService executorService = this.config.parallel() ? Executors.newCachedThreadPool() : Executors.newSingleThreadExecutor();
        CrashReportData crashReportData = new CrashReportData();
        ArrayList futures = new ArrayList();
        for (Collector collector : this.collectors) {
            futures.add(executorService.submit(() -> {
                try {
                    if (ACRA.DEV_LOGGING) {
                        ACRA.log.d(ACRA.LOG_TAG, "Calling collector " + collector.getClass().getName());
                    }
                    collector.collect(this.context, this.config, builder, crashReportData);
                    if (ACRA.DEV_LOGGING) {
                        ACRA.log.d(ACRA.LOG_TAG, "Collector " + collector.getClass().getName() + " completed");
                    }
                }
                catch (CollectorException e) {
                    ACRA.log.w(ACRA.LOG_TAG, e);
                }
                catch (Throwable t) {
                    ACRA.log.e(ACRA.LOG_TAG, "Error in collector " + collector.getClass().getSimpleName(), t);
                }
            }));
        }
        block4: for (Future future : futures) {
            while (!future.isDone()) {
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    continue block4;
                }
            }
        }
        return crashReportData;
    }

    public void collectStartUp() {
        for (Collector collector : this.collectors) {
            if (!(collector instanceof ApplicationStartupCollector)) continue;
            try {
                ((ApplicationStartupCollector)collector).collectApplicationStartUp(this.context, this.config);
            }
            catch (Throwable t) {
                ACRA.log.w(ACRA.LOG_TAG, collector.getClass().getSimpleName() + " failed to collect its startup data", t);
            }
        }
    }
}

