/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.support.annotation.NonNull;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.ApplicationStartupCollector;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;

public final class TimeCollector
extends BaseReportFieldCollector
implements ApplicationStartupCollector {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ", Locale.ENGLISH);
    private Calendar appStartDate;

    public TimeCollector() {
        super(ReportField.USER_APP_START_DATE, ReportField.USER_CRASH_DATE);
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) {
        Calendar time;
        switch (reportField) {
            case USER_APP_START_DATE: {
                time = this.appStartDate;
                break;
            }
            case USER_CRASH_DATE: {
                time = new GregorianCalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        target.put(reportField, this.getTimeString(time));
    }

    @Override
    public void collectApplicationStartUp(@NonNull Context context, @NonNull CoreConfiguration config) {
        if (config.reportContent().contains((Object)ReportField.USER_APP_START_DATE)) {
            this.appStartDate = new GregorianCalendar();
        }
    }

    @Override
    boolean shouldCollect(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportField collect, @NonNull ReportBuilder reportBuilder) {
        return collect == ReportField.USER_CRASH_DATE || super.shouldCollect(context, config, collect, reportBuilder);
    }

    @NonNull
    private String getTimeString(@NonNull Calendar time) {
        return this.dateFormat.format(time.getTimeInMillis());
    }
}

