/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.jersey.common.logging;

import cd.connect.app.config.ConfigKey;
import cd.connect.context.ConnectContext;
import cd.connect.jersey.common.logging.JerseyFiltering;
import cd.connect.jersey.common.logging.JerseyLoggerPoint;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JerseyFilteringConfiguration
implements JerseyFiltering {
    private Set<String> excludeUri = this.deconstructConfiguration(this.excludeBodyUris);
    private Set<String> excludeEntirelyUri = this.deconstructConfiguration(this.excludeEntirelyUris);
    @ConfigKey(value="jersey.exclude")
    protected String exclude = "";
    @ConfigKey(value="jersey.tracing")
    protected String tracing = "";
    @ConfigKey(value="jersey.bufferSize")
    protected Integer bufferSize = 8092;
    @ConfigKey(value="jersey.logging.exclude-body-uris")
    protected String excludeBodyUris = "";
    @ConfigKey(value="jersey.logging.exclude-entirely-uris")
    protected String excludeEntirelyUris = "";

    private Set<String> deconstructConfiguration(String toSplit) {
        return Stream.of(toSplit.split(",")).filter(Objects::nonNull).map(String::trim).filter(s -> s.length() > 0).collect(Collectors.toSet());
    }

    @Override
    public boolean excludePayloadForUri(String uriPath) {
        if (this.excludeUri.contains(uriPath)) {
            if (JerseyLoggerPoint.logger.isTraceEnabled()) {
                ConnectContext.set((String)"connect.rest.method", (Object)("exclude payload logging for uriPath:" + uriPath));
                JerseyLoggerPoint.logger.trace("no payload");
                ConnectContext.remove((String)"connect.rest.method");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean excludeForUri(String uriPath) {
        return this.excludeEntirelyUri.contains(uriPath);
    }

    @Override
    public int maxBodySize() {
        return this.bufferSize;
    }

    @Override
    public String getExclude() {
        return this.exclude;
    }

    @Override
    public String getTracing() {
        return this.tracing;
    }
}

