/*
 * Decompiled with CFR 0.152.
 */
package cc.protea.foundation.utility.services.passwordReset;

import cc.protea.foundation.integrations.EmailUtil;
import cc.protea.foundation.integrations.IntercomUtil;
import cc.protea.foundation.integrations.RedisUtil;
import cc.protea.foundation.model.ProteaException;
import cc.protea.foundation.util.KeyUtil;
import cc.protea.foundation.util.UrlUtil;
import cc.protea.foundation.utility.ProfoundConfiguration;
import cc.protea.foundation.utility.ProteaUser;
import cc.protea.foundation.utility.UserUtil;
import cc.protea.foundation.utility.providers.IntercomEvent;
import cc.protea.foundation.utility.services.GenericResponse;
import cc.protea.foundation.utility.services.passwordReset.PasswordResetRequest;
import cc.protea.foundation.utility.services.passwordReset.PasswordResetValidateResponse;
import io.intercom.api.Event;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import redis.clients.jedis.Jedis;

public class PasswordResetController {
    public static GenericResponse reset(PasswordResetRequest request) {
        request.sanitize();
        if (StringUtils.isBlank((CharSequence)request.emailAddress)) {
            throw new ProteaException(Response.Status.BAD_REQUEST, "Email address is required");
        }
        if (PasswordResetController.isLocked(request.emailAddress)) {
            return GenericResponse.success();
        }
        Integer userId = UserUtil.getUserIdByEmail(request.emailAddress);
        if (userId == null) {
            return GenericResponse.success();
        }
        String token = PasswordResetController.createToken(userId, request.emailAddress);
        String url = UrlUtil.addParameter((String)request.url, (String)"token", (String)token);
        PasswordResetController.sendResetEmail(request.emailAddress, token, url);
        IntercomUtil.create((Event)IntercomEvent.create(userId, IntercomEvent.REQUEST_PASSSWORD_RESET).putMetadata("emailAddress", request.emailAddress));
        return GenericResponse.success();
    }

    public static PasswordResetValidateResponse validate(String token) {
        PasswordResetValidateResponse response = new PasswordResetValidateResponse();
        Integer userId = PasswordResetController.validateToken(token);
        if (userId == null) {
            response.success = false;
            response.message = "Invalid token";
        } else {
            response.success = true;
            response.id = KeyUtil.toString((Number)userId);
            ProteaUser user = UserUtil.getProteaUser(userId);
            response.name = (String)StringUtils.defaultIfBlank((CharSequence)user.name, (CharSequence)(user.firstName + " " + user.lastName));
        }
        return response;
    }

    public static GenericResponse updatePassword(String token, String password) {
        Integer userId = PasswordResetController.validateToken(token);
        if (userId == null) {
            return GenericResponse.failure("Invalid token");
        }
        UserUtil.setPassword(userId, password);
        PasswordResetController.removeToken(token);
        IntercomUtil.create((Event)IntercomEvent.create(userId, IntercomEvent.PERFORM_PASSWORD_RESET));
        return GenericResponse.success(userId);
    }

    static boolean isLocked(final String emailAddress) {
        return (Boolean)RedisUtil.execute((RedisUtil.WithJedis)new RedisUtil.WithJedis<Boolean>(){

            public Boolean process(Jedis jedis) {
                return jedis.exists("passwordReset:lock" + emailAddress);
            }
        });
    }

    static String createToken(final Integer userId, final String emailAddress) {
        final String token = RandomStringUtils.randomAlphanumeric((int)50);
        RedisUtil.jedis((RedisUtil.WithJedisNull)new RedisUtil.WithJedisNull(){

            public void process(Jedis jedis) {
                jedis.setex("passwordReset:" + token, (int)TimeUnit.SECONDS.convert(1L, TimeUnit.DAYS), userId.toString());
                jedis.setex("passwordReset:lock:" + emailAddress, (int)TimeUnit.SECONDS.convert(5L, TimeUnit.MINUTES), "");
            }
        });
        return token;
    }

    static void removeToken(final String token) {
        RedisUtil.jedis((RedisUtil.WithJedisNull)new RedisUtil.WithJedisNull(){

            public void process(Jedis jedis) {
                jedis.del("passwordReset:" + token);
            }
        });
    }

    static Integer validateToken(final String token) {
        return (Integer)RedisUtil.execute((RedisUtil.WithJedis)new RedisUtil.WithJedis<Integer>(){

            public Integer process(Jedis jedis) {
                return NumberUtils.createInteger((String)jedis.get("passwordReset:" + token));
            }
        });
    }

    static void sendResetEmail(String emailAddress, String token, String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (ProfoundConfiguration.systemEmails.passwordResetTemplate != null) {
            map.put("token", token);
            EmailUtil.send((String)ProfoundConfiguration.systemEmails.passwordResetTemplate, (String)emailAddress, null, map);
            return;
        }
        String headline = "Password Reset";
        String body = "<p>You are receiving this because you (or someone else) has requested the reset of this account.</p><p>Please click on the following link to continue the process: <br/>" + url + "</p>" + "<p>If you received this in error you may safely ignore it.  This link will expire shortly.</p>";
        if (ProfoundConfiguration.systemEmails.defaultTemplate != null) {
            map.put("headline", headline);
            map.put("body", body);
            EmailUtil.send((String)ProfoundConfiguration.systemEmails.defaultTemplate, (String)"Password Reset", null, null, (String)emailAddress, null, map);
            return;
        }
    }
}

