/*
 * Decompiled with CFR 0.152.
 */
package cc.protea.foundation.utility.services.login;

import cc.protea.foundation.integrations.FacebookUtil;
import cc.protea.foundation.integrations.GoogleUtil;
import cc.protea.foundation.integrations.IntercomUtil;
import cc.protea.foundation.integrations.LinkedInUtil;
import cc.protea.foundation.integrations.TwitterUtil;
import cc.protea.foundation.utility.SessionUtil;
import cc.protea.foundation.utility.UserUtil;
import cc.protea.foundation.utility.services.login.AuthenticationRequest;
import cc.protea.foundation.utility.services.login.AuthenticationResponse;
import com.google.api.services.plus.model.Person;
import io.intercom.api.Event;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AuthenticationController {
    public static AuthenticationResponse authenticate(AuthenticationRequest request) {
        request.sanitize();
        Integer userId = null;
        if (request.emailAddress != null && request.password != null) {
            userId = UserUtil.getUserIdByPassword(request.emailAddress, request.password);
            if (userId == null) {
                return AuthenticationResponse.failure("Incorrect email address or password");
            }
            AuthenticationController.sendIntercomEvent(userId);
            return AuthenticationResponse.success(SessionUtil.create(userId));
        }
        AuthenticationResponse response = new AuthenticationResponse();
        if (request.facebookAccessToken != null) {
            response.facebookUser = FacebookUtil.me((String)request.facebookAccessToken);
            if (response.facebookUser != null && (userId = UserUtil.getUserIdByFacebookId(response.facebookUser.getId())) != null) {
                AuthenticationController.sendIntercomEvent(userId);
                return AuthenticationResponse.success(SessionUtil.create(userId));
            }
        }
        if (request.googlePlusAccessToken != null) {
            response.googleUser = GoogleUtil.me((String)request.googlePlusAccessToken);
            if (response.googleUser != null && (userId = UserUtil.getUserIdByGoogleId(response.googleUser.getId())) != null) {
                AuthenticationController.sendIntercomEvent(userId);
                return AuthenticationResponse.success(SessionUtil.create(userId));
            }
        }
        if (request.twitterAccessToken != null) {
            response.twitterUser = TwitterUtil.me((String)request.twitterAccessToken);
            if (response.twitterUser != null) {
                userId = UserUtil.getUserIdByTwitterId(response.twitterUser.getId());
            }
        }
        if (request.linkedInAccessToken != null) {
            response.linkedInUser = LinkedInUtil.me((String)request.linkedInAccessToken);
            if (response.linkedInUser != null) {
                userId = UserUtil.getUserIdByLinkedInId(response.linkedInUser.id);
            }
        }
        if (response.facebookUser != null) {
            userId = UserUtil.getUserIdByEmail(response.facebookUser.getEmail());
            if (userId != null) {
                UserUtil.setFacebookId(userId, response.facebookUser.getId());
                AuthenticationController.sendIntercomEvent(userId);
                return AuthenticationResponse.success(SessionUtil.create(userId));
            }
            request.emailAddress = (String)StringUtils.defaultIfBlank((CharSequence)request.emailAddress, (CharSequence)response.facebookUser.getEmail());
        }
        if (response.googleUser != null) {
            for (String email : AuthenticationController.getEmails(response.googleUser)) {
                userId = UserUtil.getUserIdByEmail(email);
                if (userId != null) {
                    UserUtil.setGoogleId(userId, response.googleUser.getId());
                    AuthenticationController.sendIntercomEvent(userId);
                    return AuthenticationResponse.success(SessionUtil.create(userId));
                }
                request.emailAddress = (String)StringUtils.defaultIfBlank((CharSequence)request.emailAddress, (CharSequence)email);
            }
        }
        if (response.linkedInUser != null) {
            userId = UserUtil.getUserIdByEmail(response.linkedInUser.emailAddress);
            if (userId != null) {
                UserUtil.setLinkedInId(userId, response.linkedInUser.id);
                AuthenticationController.sendIntercomEvent(userId);
                return AuthenticationResponse.success(SessionUtil.create(userId));
            }
            request.emailAddress = (String)StringUtils.defaultIfBlank((CharSequence)request.emailAddress, (CharSequence)response.linkedInUser.emailAddress);
        }
        response.success = false;
        response.message = request.emailAddress != null && request.password != null ? "Email address and password do not match." : "Insufficient Authentication information provided";
        return response;
    }

    static void sendIntercomEvent(Integer userId) {
        Event event = new Event();
        event.setUserID("" + userId);
        event.setEventName("logged-in");
        IntercomUtil.create((Event)event);
    }

    static List<String> getEmails(Person person) {
        ArrayList<String> list = new ArrayList<String>();
        if (person == null || person.getEmails() == null) {
            return list;
        }
        String account = null;
        for (Person.Emails candidate : person.getEmails()) {
            if (candidate == null || StringUtils.isBlank((CharSequence)candidate.getValue())) continue;
            if ("account".equals(candidate.getType())) {
                account = candidate.getValue();
                continue;
            }
            if ("work".equals(candidate.getType())) {
                list.add(0, candidate.getValue());
                continue;
            }
            list.add(candidate.getValue());
        }
        if (account != null) {
            list.remove(account);
            list.add(0, account);
        }
        return list;
    }
}

