/*
 * Decompiled with CFR 0.152.
 */
package cc.protea.foundation.utility.services;

import cc.protea.foundation.model.Pojo;
import cc.protea.foundation.utility.ProteaUser;
import cc.protea.foundation.utility.UserUtil;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class ProteaService
extends Pojo {
    @Context
    SecurityContext securityContext;
    ProteaUser user = null;
    @Context
    ContainerRequestContext requestContext;
    @Context
    HttpServletRequest request;

    public ProteaUser getUser() {
        if (this.user == null) {
            this.user = UserUtil.getProteaUser(this.getUserId());
            UserUtil.updateLastSeen(this.getUserId(), this.getIpAddress());
        }
        return this.user;
    }

    public Integer getUserId() {
        if (this.securityContext == null) {
            return null;
        }
        Principal principal = this.securityContext.getUserPrincipal();
        if (principal == null) {
            return null;
        }
        return NumberUtils.createInteger((String)principal.getName());
    }

    public String getIpAddress() {
        return this.request.getRemoteAddr();
    }

    public String getSessionToken() {
        Object o = this.requestContext.getProperty("sessionToken");
        return o == null ? null : o.toString();
    }

    public String getReferrer() {
        return (String)this.requestContext.getHeaders().getFirst((Object)"Referer");
    }

    public String getUrl() {
        return this.requestContext.getUriInfo().toString();
    }
}

