/*
 * Decompiled with CFR 0.152.
 */
package cc.protea.foundation.utility;

import cc.protea.foundation.integrations.IntercomUtil;
import cc.protea.foundation.integrations.RedisUtil;
import cc.protea.foundation.util.PasswordUtil;
import cc.protea.foundation.utility.ProteaUser;
import cc.protea.foundation.utility.SessionUtil;
import cc.protea.foundation.utility.services.login.AuthenticationRequest;
import cc.protea.foundation.utility.services.login.AuthenticationResponse;
import io.intercom.api.User;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;

public class UserUtil {
    public static Set<ProteaUser> getProteaUsers(Set<String> userIds) {
        if (userIds == null) {
            return null;
        }
        HashSet<ProteaUser> set = new HashSet<ProteaUser>(userIds.size());
        for (String userId : userIds) {
            ProteaUser user = new ProteaUser();
            user.id = NumberUtils.createInteger((String)userId);
            UserUtil.fillProteaUser(user, true);
            set.add(user);
        }
        return set;
    }

    public static ProteaUser getProteaUser(String userId) {
        return UserUtil.getProteaUser(NumberUtils.createInteger((String)userId));
    }

    public static void updateLastSeen(final Integer userId, String ipAddress) {
        if (userId == null) {
            return;
        }
        IntercomUtil.updateLastSeen((Integer)userId, (String)ipAddress);
        RedisUtil.jedis((RedisUtil.WithJedisNull)new RedisUtil.WithJedisNull(){

            public void process(Jedis jedis) {
                jedis.zadd("users", (double)System.currentTimeMillis(), "" + userId);
            }
        });
    }

    public static void fillProteaUser(ProteaUser user) {
        UserUtil.fillProteaUser(user, false);
    }

    public static void fillProteaUser(final ProteaUser user, final boolean fast) {
        RedisUtil.jedis((RedisUtil.WithJedisNull)new RedisUtil.WithJedisNull(){

            public void process(Jedis jedis) {
                String key = "users:" + user.id;
                Map map = jedis.hgetAll(key);
                if (map.isEmpty()) {
                    user.id = 0;
                    return;
                }
                user.createdOn = RedisUtil.toDate((String)((String)map.get("createdOn")));
                user.primaryEmail = (String)map.get("primaryEmail");
                user.firstName = (String)map.get("firstName");
                user.organization = (String)map.get("organization");
                user.lastName = (String)map.get("lastName");
                user.name = (String)map.get("name");
                if (!fast) {
                    user.authentication.password = UserUtil.isSet(map, "encryptedPassword");
                    user.authentication.facebook = !jedis.zrangeByScore("users:facebook", (double)user.id, (double)user.id).isEmpty();
                    user.authentication.google = !jedis.zrangeByScore("users:linkedin", (double)user.id, (double)user.id).isEmpty();
                    user.authentication.linkedIn = !jedis.zrangeByScore("users:google", (double)user.id, (double)user.id).isEmpty();
                    user.authentication.twitter = !jedis.zrangeByScore("users:twitter", (double)user.id, (double)user.id).isEmpty();
                    Double lastSeen = jedis.zscore("users", "" + user.id);
                    user.lastSeen = lastSeen == null ? null : new Date(lastSeen.longValue());
                }
                user.roles.addAll(jedis.smembers(key + ":roles"));
                user.emailAddresses.addAll(jedis.smembers(key + ":emails"));
            }
        });
    }

    static boolean isSet(Map<String, String> map, String key) {
        if (map == null || key == null) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)map.get(key));
    }

    public static ProteaUser getProteaUser(Integer userId) {
        if (userId == null) {
            return null;
        }
        ProteaUser user = new ProteaUser();
        user.id = userId;
        UserUtil.fillProteaUser(user);
        return user.id == 0 ? null : user;
    }

    public static Integer getUserIdByPassword(final String email, final String password) {
        if (StringUtils.isBlank((CharSequence)email) || StringUtils.isBlank((CharSequence)password)) {
            return null;
        }
        return (Integer)RedisUtil.execute((RedisUtil.WithJedis)new RedisUtil.WithJedis<Integer>(){

            public Integer process(Jedis jedis) {
                Double userId = jedis.zscore("users:email", email);
                if (userId == null) {
                    return null;
                }
                String encrypted = jedis.hget("users:" + userId.intValue(), "encryptedPassword");
                if (PasswordUtil.doPasswordsMatch((String)StringUtils.trim((String)password), (String)encrypted)) {
                    return userId.intValue();
                }
                return null;
            }
        });
    }

    static Integer getUserIdByPointer(final String type, final String value) {
        if (type == null || value == null) {
            return null;
        }
        return (Integer)RedisUtil.execute((RedisUtil.WithJedis)new RedisUtil.WithJedis<Integer>(){

            public Integer process(Jedis jedis) {
                Double d = jedis.zscore("users:" + type, value);
                return d == null ? null : Integer.valueOf(d.intValue());
            }
        });
    }

    static void setUserPointer(final Integer userId, final String type, final String value) {
        if (userId == null || type == null) {
            return;
        }
        RedisUtil.jedis((RedisUtil.WithJedisNull)new RedisUtil.WithJedisNull(){

            public void process(Jedis jedis) {
                String key = "users:" + type;
                if (value == null) {
                    jedis.zremrangeByScore(key, (double)userId.intValue(), (double)userId.intValue());
                } else {
                    jedis.zadd(key, (double)userId.intValue(), value);
                }
            }
        });
    }

    public static Integer getUserIdByFacebookId(String facebookId) {
        return UserUtil.getUserIdByPointer("facebook", facebookId);
    }

    public static void setFacebookId(Integer userId, String facebookId) {
        UserUtil.setUserPointer(userId, "facebook", facebookId);
    }

    public static Integer getUserIdByGoogleId(String googleId) {
        return UserUtil.getUserIdByPointer("google", googleId);
    }

    public static void setGoogleId(Integer userId, String googleId) {
        UserUtil.setUserPointer(userId, "google", googleId);
    }

    public static Integer getUserIdByTwitterId(Long twitterId) {
        return UserUtil.getUserIdByPointer("twitter", twitterId == null ? null : twitterId.toString());
    }

    public static void setTwitterId(Integer userId, Long twitterId) {
        UserUtil.setUserPointer(userId, "twitter", twitterId == null ? null : twitterId.toString());
    }

    public static Integer getUserIdByLinkedInId(String linkedInId) {
        return UserUtil.getUserIdByPointer("linkedin", linkedInId == null ? null : linkedInId);
    }

    public static void setLinkedInId(Integer userId, String linkedInId) {
        UserUtil.setUserPointer(userId, "linkedin", linkedInId == null ? null : linkedInId);
    }

    public static Integer getUserIdByEmail(String email) {
        return UserUtil.getUserIdByPointer("email", email);
    }

    public static void addEmail(final Integer userId, String email) {
        if (StringUtils.isBlank((CharSequence)email) || userId == null) {
            return;
        }
        final String trimmed = StringUtils.trim((String)email);
        UserUtil.setUserPointer(userId, "email", trimmed);
        RedisUtil.jedis((RedisUtil.WithJedisNull)new RedisUtil.WithJedisNull(){

            public void process(Jedis jedis) {
                jedis.hsetnx("users:" + userId, "primaryEmail", trimmed);
            }
        });
    }

    public static void setPassword(final Integer userId, String password) {
        if (StringUtils.isBlank((CharSequence)password) || userId == null) {
            return;
        }
        final String encrypted = PasswordUtil.encryptPassword((String)password);
        RedisUtil.jedis((RedisUtil.WithJedisNull)new RedisUtil.WithJedisNull(){

            public void process(Jedis jedis) {
                jedis.hset("users:" + userId, "encryptedPassword", encrypted);
            }
        });
    }

    public static Integer add() {
        return UserUtil.add(new AuthenticationRequest(), new AuthenticationResponse());
    }

    public static Integer add(final AuthenticationRequest request, final AuthenticationResponse response) {
        UserUtil.addResponseInformation(request, response);
        final Integer userId = (Integer)RedisUtil.execute((RedisUtil.WithJedis)new RedisUtil.WithJedis<Integer>(){

            public Integer process(Jedis jedis) {
                Long userId = jedis.incr("users:sequence");
                String userKey = "users:" + userId;
                Transaction t = jedis.multi();
                t.zadd("users", (double)System.currentTimeMillis(), userId.toString());
                t.hset(userKey, "createdOn", RedisUtil.toDate((Date)new Date()));
                if (StringUtils.isNotBlank((CharSequence)request.emailAddress)) {
                    t.zadd("users:email", (double)userId.longValue(), StringUtils.trim((String)request.emailAddress));
                    t.hset(userKey, "primaryEmail", StringUtils.trim((String)request.emailAddress));
                }
                if (response.facebookUser != null) {
                    t.zadd("users:facebook", (double)userId.longValue(), response.facebookUser.getId());
                }
                if (response.googleUser != null) {
                    t.zadd("users:google", (double)userId.longValue(), response.googleUser.getId());
                }
                if (response.twitterUser != null) {
                    t.zadd("users:twitter", (double)userId.longValue(), "" + response.twitterUser.getId());
                }
                if (response.linkedInUser != null) {
                    t.zadd("users:linkedin", (double)userId.longValue(), response.linkedInUser.id);
                }
                if (StringUtils.isNotBlank((CharSequence)request.firstName)) {
                    t.hset(userKey, "firstName", StringUtils.trim((String)request.firstName));
                }
                if (StringUtils.isNotBlank((CharSequence)request.lastName)) {
                    t.hset(userKey, "lastName", StringUtils.trim((String)request.lastName));
                }
                if (StringUtils.isNotBlank((CharSequence)request.name)) {
                    t.hset(userKey, "name", StringUtils.trim((String)request.name));
                }
                if (StringUtils.isNotBlank((CharSequence)request.password)) {
                    t.hset(userKey, "encryptedPassword", PasswordUtil.encryptPassword((String)request.password));
                }
                t.exec();
                return userId.intValue();
            }
        });
        if (StringUtils.isNotBlank((CharSequence)request.emailAddress)) {
            User user = new User().setEmail(request.emailAddress).setUserId(userId.toString());
            final User saved = IntercomUtil.create((User)user);
            if (user != null && saved != null) {
                RedisUtil.redis((RedisUtil.WithJedisNull)new RedisUtil.WithJedisNull(){

                    public void process(Jedis jedis) {
                        jedis.hset("users:" + userId, "intercom", saved.getId());
                    }
                });
            }
        }
        return userId;
    }

    static void addResponseInformation(AuthenticationRequest request, AuthenticationResponse response) {
        if (request.firstName == null) {
            request.firstName = response.getFirstName();
        }
        if (request.lastName == null) {
            request.lastName = response.getLastName();
        }
        if (request.name == null) {
            request.name = response.getName();
        }
    }

    public static Set<String> getSessionsForUser(final Integer userId) {
        if (userId == null) {
            return null;
        }
        return (Set)RedisUtil.execute((RedisUtil.WithJedis)new RedisUtil.WithJedis<Set<String>>(){

            public Set<String> process(Jedis jedis) {
                return jedis.zrangeByScore("users:sessions", (double)userId.intValue(), (double)userId.intValue());
            }
        });
    }

    public static void remove(final Integer userId) {
        if (userId == null) {
            return;
        }
        RedisUtil.jedis((RedisUtil.WithJedisNull)new RedisUtil.WithJedisNull(){

            public void process(Jedis jedis) {
                Set sessions = jedis.zrangeByScore("users:sessions", (double)userId.intValue(), (double)userId.intValue());
                for (String session : sessions) {
                    SessionUtil.remove(session);
                }
                Transaction t = jedis.multi();
                t.zrem("users", new String[]{userId.toString()});
                t.del("users:" + userId + ":roles");
                t.del("users:" + userId);
                t.zremrangeByScore("users:twitter", (double)userId.intValue(), (double)userId.intValue());
                t.zremrangeByScore("users:facebook", (double)userId.intValue(), (double)userId.intValue());
                t.zremrangeByScore("users:linkedin", (double)userId.intValue(), (double)userId.intValue());
                t.zremrangeByScore("users:google", (double)userId.intValue(), (double)userId.intValue());
                t.zremrangeByScore("users:email", (double)userId.intValue(), (double)userId.intValue());
                t.exec();
            }
        });
    }

    public static void addRole(final Integer userId, final String role) {
        if (userId == null || StringUtils.isBlank((CharSequence)role)) {
            return;
        }
        RedisUtil.transaction((RedisUtil.WithTransaction)new RedisUtil.WithTransaction(){

            public void process(Transaction transaction) {
                transaction.sadd("users:" + userId + ":roles", new String[]{role});
                transaction.sadd("users:roles:" + role, new String[]{userId.toString()});
            }
        });
    }

    public static void removeRole(final Integer userId, final String role) {
        if (userId == null || StringUtils.isBlank((CharSequence)role)) {
            return;
        }
        RedisUtil.transaction((RedisUtil.WithTransaction)new RedisUtil.WithTransaction(){

            public void process(Transaction transaction) {
                transaction.srem("users:" + userId + ":roles", new String[]{role});
                transaction.srem("users:roles:", new String[]{userId.toString()});
            }
        });
    }

    public static Set<Integer> getUserIdsInRole(final String role) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (StringUtils.isBlank((CharSequence)role)) {
            return set;
        }
        Set strings = (Set)RedisUtil.execute((RedisUtil.WithJedis)new RedisUtil.WithJedis<Set<String>>(){

            public Set<String> process(Jedis jedis) {
                return jedis.smembers(role);
            }
        });
        for (String string : strings) {
            set.add(NumberUtils.createInteger((String)string));
        }
        return set;
    }

    public static boolean isUserInRole(final Integer userId, final String role) {
        if (userId == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)role)) {
            return true;
        }
        return (Boolean)RedisUtil.execute((RedisUtil.WithJedis)new RedisUtil.WithJedis<Boolean>(){

            public Boolean process(Jedis jedis) {
                return jedis.sismember("users:" + userId + ":roles", role);
            }
        });
    }
}

