/*
 * Decompiled with CFR 0.152.
 */
package cc.protea.foundation.utility;

import cc.protea.foundation.integrations.RedisUtil;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;

public class SessionUtil {
    public static Integer getUserId(final String token) {
        return (Integer)RedisUtil.execute((RedisUtil.WithJedis)new RedisUtil.WithJedis<Integer>(){

            public Integer process(Jedis jedis) {
                List list = jedis.hmget("sessions:" + StringUtils.trim((String)token), new String[]{"userId", "expireSeconds"});
                String userString = (String)list.get(0);
                if (!StringUtils.isNumeric((CharSequence)userString)) {
                    return null;
                }
                Number expireSeconds = NumberUtils.createNumber((String)((String)list.get(1)));
                if (expireSeconds != null) {
                    Long expires = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(expireSeconds.longValue(), TimeUnit.SECONDS);
                    jedis.zadd("sessions", (double)expires.longValue(), StringUtils.trim((String)token));
                }
                return NumberUtils.createInteger((String)userString);
            }
        });
    }

    public static String create(final Integer userId) {
        if (userId == null) {
            return null;
        }
        final String token = RandomStringUtils.randomAlphanumeric((int)30);
        final HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId.toString());
        RedisUtil.jedis((RedisUtil.WithJedisNull)new RedisUtil.WithJedisNull(){

            public void process(Jedis jedis) {
                Transaction t = jedis.multi();
                t.hmset("sessions:" + token, map);
                t.zadd("sessions", Double.MAX_VALUE, token);
                t.zadd("users:sessions", (double)userId.intValue(), token);
                t.exec();
            }
        });
        return token;
    }

    public static void remove(String token) {
        if (token == null) {
            return;
        }
        final String trimmed = StringUtils.trim((String)token);
        RedisUtil.jedis((RedisUtil.WithJedisNull)new RedisUtil.WithJedisNull(){

            public void process(Jedis jedis) {
                Transaction t = jedis.multi();
                t.zrem("sessions", new String[]{trimmed});
                t.del("sessions:" + trimmed);
                t.zrem("users:sessions", new String[]{trimmed});
                t.exec();
            }
        });
    }
}

