/*
 * Decompiled with CFR 0.152.
 */
package jsonij.jpath;

import java.util.Locale;
import java.util.ResourceBundle;

public class JPathRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -4761587256432880263L;
    public static final String MESSAGE_BUNDLE = "JPathMessageBundle";
    protected String key;
    protected String message;
    protected Locale locale;

    public JPathRuntimeException(String key, Object ... args) {
        this(key, null, args);
    }

    public JPathRuntimeException(String key, Locale locale, Object ... args) {
        this.key = key;
        Locale locale2 = this.locale = locale == null ? Locale.ENGLISH : locale;
        if (this.locale != null) {
            String messageFormat = ResourceBundle.getBundle(this.getBundleName(), this.locale).getString(this.key);
            this.message = String.format(messageFormat, args);
        } else {
            this.message = String.format("Undefined Exception %s %s", key, locale);
        }
    }

    public String getBundleName() {
        return MESSAGE_BUNDLE;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

