/*
 * Decompiled with CFR 0.152.
 */
package jsonij.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class LittleEndianRandomAccessFile
implements DataInput,
DataOutput {
    protected byte[] buffer;
    protected RandomAccessFile randomAccessFile;

    public LittleEndianRandomAccessFile(File file, String mode) throws FileNotFoundException {
        this.randomAccessFile = new RandomAccessFile(file, mode);
        this.buffer = new byte[8];
    }

    public LittleEndianRandomAccessFile(String file, String mode) throws FileNotFoundException {
        this.randomAccessFile = new RandomAccessFile(file, mode);
        this.buffer = new byte[8];
    }

    public final void close() throws IOException {
        this.randomAccessFile.close();
    }

    public final FileDescriptor getFD() throws IOException {
        return this.randomAccessFile.getFD();
    }

    public final long getFilePointer() throws IOException {
        return this.randomAccessFile.getFilePointer();
    }

    public final long length() throws IOException {
        return this.randomAccessFile.length();
    }

    public final int read() throws IOException {
        return this.randomAccessFile.read();
    }

    public final int read(byte[] ba) throws IOException {
        return this.randomAccessFile.read(ba);
    }

    public final int read(byte[] ba, int off, int len) throws IOException {
        return this.randomAccessFile.read(ba, off, len);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.randomAccessFile.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.randomAccessFile.readByte();
    }

    @Override
    public final char readChar() throws IOException {
        this.randomAccessFile.readFully(this.buffer, 0, 2);
        return (char)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.randomAccessFile.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.randomAccessFile.readFully(b, off, len);
    }

    @Override
    public final int readInt() throws IOException {
        this.randomAccessFile.readFully(this.buffer, 0, 4);
        return this.buffer[3] << 24 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    @Override
    public final String readLine() throws IOException {
        return this.randomAccessFile.readLine();
    }

    @Override
    public final long readLong() throws IOException {
        this.randomAccessFile.readFully(this.buffer, 0, 8);
        return (long)this.buffer[7] << 56 | (long)(this.buffer[6] & 0xFF) << 48 | (long)(this.buffer[5] & 0xFF) << 40 | (long)(this.buffer[4] & 0xFF) << 32 | (long)(this.buffer[3] & 0xFF) << 24 | (long)(this.buffer[2] & 0xFF) << 16 | (long)(this.buffer[1] & 0xFF) << 8 | (long)(this.buffer[0] & 0xFF);
    }

    @Override
    public final short readShort() throws IOException {
        this.randomAccessFile.readFully(this.buffer, 0, 2);
        return (short)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    @Override
    public final String readUTF() throws IOException {
        return this.randomAccessFile.readUTF();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.randomAccessFile.readUnsignedByte();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.randomAccessFile.readFully(this.buffer, 0, 2);
        return (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    public final void seek(long pos) throws IOException {
        this.randomAccessFile.seek(pos);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.randomAccessFile.skipBytes(n);
    }

    @Override
    public final synchronized void write(int b) throws IOException {
        this.randomAccessFile.write(b);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.randomAccessFile.write(b, 0, b.length);
    }

    @Override
    public final synchronized void write(byte[] b, int off, int len) throws IOException {
        this.randomAccessFile.write(b, off, len);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.randomAccessFile.writeBoolean(v);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.randomAccessFile.writeByte(v);
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        this.randomAccessFile.writeBytes(s);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.buffer[0] = (byte)v;
        this.buffer[1] = (byte)(v >> 8);
        this.randomAccessFile.write(this.buffer, 0, 2);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.buffer[0] = (byte)v;
        this.buffer[1] = (byte)(v >> 8);
        this.buffer[2] = (byte)(v >> 16);
        this.buffer[3] = (byte)(v >> 24);
        this.randomAccessFile.write(this.buffer, 0, 4);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.buffer[0] = (byte)v;
        this.buffer[1] = (byte)(v >> 8);
        this.buffer[2] = (byte)(v >> 16);
        this.buffer[3] = (byte)(v >> 24);
        this.buffer[4] = (byte)(v >> 32);
        this.buffer[5] = (byte)(v >> 40);
        this.buffer[6] = (byte)(v >> 48);
        this.buffer[7] = (byte)(v >> 56);
        this.randomAccessFile.write(this.buffer, 0, 8);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.buffer[0] = (byte)v;
        this.buffer[1] = (byte)(v >> 8);
        this.randomAccessFile.write(this.buffer, 0, 2);
    }

    @Override
    public final void writeUTF(String s) throws IOException {
        this.randomAccessFile.writeUTF(s);
    }
}

