/*
 * Decompiled with CFR 0.152.
 */
package jsonij;

import jsonij.BitWiseException;

public class BitWiseUtils {
    public static final short BYTE_BIT_COUNT = 8;
    public static final short SHORT_BIT_COUNT = 16;
    public static final short INT_BIT_COUNT = 32;
    public static final short LONG_BIT_COUNT = 64;
    public static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static final String convertToBinaryString(byte value) {
        StringBuilder outputBuilder = new StringBuilder();
        for (int i = 7; i >= 0; --i) {
            outputBuilder.append(value >> i & 1);
        }
        return outputBuilder.toString();
    }

    public static final String convertToBinaryString(short value) {
        StringBuilder outputBuilder = new StringBuilder();
        for (int i = 15; i >= 0; --i) {
            outputBuilder.append(value >> i & 1);
        }
        return outputBuilder.toString();
    }

    public static final String convertToBinaryString(int value) {
        StringBuilder outputBuilder = new StringBuilder();
        for (int i = 31; i >= 0; --i) {
            outputBuilder.append(value >> i & 1);
        }
        return outputBuilder.toString();
    }

    public static final String convertToHexString(byte value) {
        return "" + HEX_ARRAY[value >>> 4] + HEX_ARRAY[value & 0xF];
    }

    public static final String convertToHexString(short value) {
        return "" + HEX_ARRAY[value >>> 12] + HEX_ARRAY[value >>> 8 & 0xF] + HEX_ARRAY[value >>> 4 & 0xF] + HEX_ARRAY[value & 0xF];
    }

    public static final String convertToHexString(int value) {
        return "" + HEX_ARRAY[value >>> 28] + HEX_ARRAY[value >>> 24 & 0xF] + HEX_ARRAY[value >>> 20 & 0xF] + HEX_ARRAY[value >>> 16 & 0xF] + HEX_ARRAY[value >>> 12 & 0xF] + HEX_ARRAY[value >>> 8 & 0xF] + HEX_ARRAY[value >>> 4 & 0xF] + HEX_ARRAY[value & 0xF];
    }

    public static final boolean extractBooleanFromBits(byte value, int offset) throws BitWiseException {
        if (offset > 8) {
            throw new BitWiseException("overflow");
        }
        return (value & 1 << 8 - offset - 1) != 0;
    }

    public static final boolean extractBooleanFromBits(short value, int offset) throws BitWiseException {
        if (offset > 16) {
            throw new BitWiseException("overflow");
        }
        return (value & 1 << 16 - offset - 1) != 0;
    }

    public static final byte extractByteFromBits(byte value, int offset, int bitCount) throws BitWiseException {
        if (offset + bitCount > 8) {
            throw new BitWiseException("overflow");
        }
        byte recycleType = 0;
        int rotate = 8 - offset - bitCount;
        for (int i = offset; i < offset + bitCount; ++i) {
            recycleType = (byte)(recycleType | (value & 1 << 8 - i - 1) >>> rotate);
        }
        return recycleType;
    }

    public static final byte extractShortFromBits(short value, int offset, int bitCount) throws BitWiseException {
        if (offset + bitCount > 16) {
            throw new BitWiseException("overflow");
        }
        byte recycleType = 0;
        int rotate = 16 - offset - bitCount;
        for (int i = offset; i < offset + bitCount; ++i) {
            recycleType = (byte)(recycleType | (value & 1 << 16 - i - 1) >>> rotate);
        }
        return recycleType;
    }

    public static final byte extractByteFromBits(short value, int offset, int bitCount) throws BitWiseException {
        if (offset + bitCount > 16) {
            throw new BitWiseException("overflow");
        }
        byte recycleType = 0;
        int rotate = 16 - offset - bitCount;
        for (int i = offset; i < offset + bitCount; ++i) {
            recycleType = (byte)(recycleType | (value & 1 << 16 - i - 1) >>> rotate);
        }
        return recycleType;
    }

    public static final byte extractByteFromBits(int value, int offset, int bitCount) throws BitWiseException {
        if (offset + bitCount > 32) {
            throw new BitWiseException("overflow");
        }
        byte recycleType = 0;
        int rotate = 32 - offset - bitCount;
        for (int i = offset; i < offset + bitCount; ++i) {
            recycleType = (byte)(recycleType | (value & 1 << 32 - i - 1) >>> rotate);
        }
        return recycleType;
    }

    public static final byte extractByteFromBits(long value, int offset, int bitCount) throws BitWiseException {
        if (offset + bitCount > 64) {
            throw new BitWiseException("overflow");
        }
        byte recycleType = 0;
        int rotate = 64 - offset - bitCount;
        for (int i = offset; i < offset + bitCount; ++i) {
            recycleType = (byte)((long)recycleType | (value & (long)(1 << 64 - i - 1)) >>> rotate);
        }
        return recycleType;
    }
}

