/*
 * Decompiled with CFR 0.152.
 */
package jsonij.parser;

import jsonij.ConstantUtility;
import jsonij.parser.BaseJSONReader;
import jsonij.parser.JSONReader;
import jsonij.parser.ParserException;
import jsonij.parser.Position;

public class StringJSONReader
extends BaseJSONReader
implements JSONReader {
    protected String jsonString;
    protected int index;
    protected int length;
    protected final StringJSONStringReader stringReader;
    private int peekRead;

    public StringJSONReader(String jsonString) {
        if (jsonString == null) {
            throw new NullPointerException("Null String Exception.");
        }
        this.jsonString = jsonString;
        this.length = jsonString.length();
        this.stringReader = new StringJSONStringReader();
        this.index = 0;
        this.peekRead = -1;
    }

    public StringJSONReader(String jsonString, int index) {
        if (jsonString == null) {
            throw new NullPointerException("Null String Exception.");
        }
        this.jsonString = jsonString;
        this.length = jsonString.length();
        this.stringReader = new StringJSONStringReader();
        this.index = index;
        this.position.setPostionNumber(index);
        this.peekRead = -1;
    }

    public void setJSONString(String jsonString) {
        if (jsonString == null) {
            throw new NullPointerException("Null String Exception.");
        }
        this.jsonString = jsonString;
        this.length = jsonString.length();
        this.index = 0;
        this.peekRead = -1;
    }

    public void setJSONString(String jsonString, int index) {
        if (jsonString == null) {
            throw new NullPointerException("Null String Exception.");
        }
        this.jsonString = jsonString;
        this.length = jsonString.length();
        this.index = index;
        this.position.setPostionNumber(index);
        this.peekRead = -1;
    }

    public String getJSONString() {
        return this.jsonString;
    }

    @Override
    public int readNext() throws ParserException {
        int r = -1;
        while (this.peekRead != -1 || this.index < this.length) {
            if (this.peekRead != -1) {
                r = this.peekRead;
                this.peekRead = -1;
            } else {
                r = this.jsonString.charAt(this.index++);
                this.position.movePosition();
            }
            if (ConstantUtility.isComment(r) && this.index < this.length) {
                char pr;
                if (ConstantUtility.isComment(pr = this.jsonString.charAt(this.index++))) {
                    do {
                        r = this.jsonString.charAt(this.index++);
                        this.position.movePosition();
                    } while (this.index < this.length && !ConstantUtility.isReturn(r) && !ConstantUtility.isNewLine(r));
                    if (this.index >= this.length) {
                        r = -1;
                    }
                } else {
                    this.peekRead = pr;
                    break;
                }
            }
            if (ConstantUtility.isReturn(r)) {
                this.handleNewLine();
                if (this.index >= this.length) break;
                if (ConstantUtility.isNewLine(r = (int)this.jsonString.charAt(this.index++)) && this.index < this.length) {
                    r = this.jsonString.charAt(this.index++);
                }
            }
            if (ConstantUtility.isNewLine(r)) {
                this.handleNewLine();
                if (this.index < this.length) {
                    r = this.jsonString.charAt(this.index++);
                }
            }
            if (ConstantUtility.isComment(r)) {
                this.peekRead = r;
                continue;
            }
            if (ConstantUtility.isWhiteSpace(r) || ConstantUtility.isReturn(r) || ConstantUtility.isNewLine(r)) continue;
        }
        if (ConstantUtility.isReturn(r) || ConstantUtility.isNewLine(r) || ConstantUtility.isWhiteSpace(r)) {
            r = -1;
        }
        return r;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public JSONReader getStringReader(JSONReader.Mode mode) {
        this.stringReader.setActive(true);
        this.stringReader.setMode(mode);
        return this.stringReader;
    }

    protected class StringJSONStringReader
    implements JSONReader {
        protected JSONReader.Mode mode = JSONReader.Mode.QUOTED_READING;
        public boolean active = true;

        public JSONReader.Mode getMode() {
            return this.mode;
        }

        public void setMode(JSONReader.Mode mode) {
            this.mode = mode;
        }

        public boolean isActive() {
            return this.active;
        }

        protected void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public int peek() throws ParserException {
            if (!StringJSONReader.this.hasPeeked) {
                if (!this.active) {
                    return -1;
                }
                StringJSONReader.this.peekValue = this.readNext();
                StringJSONReader.this.hasPeeked = true;
            }
            return StringJSONReader.this.peekValue;
        }

        @Override
        public int read() throws ParserException {
            if (!this.active) {
                return -1;
            }
            if (StringJSONReader.this.hasPeeked) {
                StringJSONReader.this.hasPeeked = false;
                return StringJSONReader.this.peekValue;
            }
            return this.readNext();
        }

        @Override
        public void close() {
            this.active = false;
        }

        protected int readNext() throws ParserException {
            int r = -1;
            if (StringJSONReader.this.index < StringJSONReader.this.length) {
                while (StringJSONReader.this.peekRead != -1 || StringJSONReader.this.index < StringJSONReader.this.length) {
                    if (StringJSONReader.this.peekRead != -1) {
                        r = StringJSONReader.this.peekRead;
                        StringJSONReader.this.peekRead = -1;
                    } else {
                        r = StringJSONReader.this.jsonString.charAt(StringJSONReader.this.index++);
                        StringJSONReader.this.position.movePosition();
                    }
                    if (this.mode == JSONReader.Mode.QUOTED_READING) break;
                    if (ConstantUtility.isComment(r) && StringJSONReader.this.index < StringJSONReader.this.length) {
                        char pr;
                        if (ConstantUtility.isComment(pr = StringJSONReader.this.jsonString.charAt(StringJSONReader.this.index++))) {
                            do {
                                r = StringJSONReader.this.jsonString.charAt(StringJSONReader.this.index++);
                                StringJSONReader.this.position.movePosition();
                            } while (StringJSONReader.this.index < StringJSONReader.this.length && !ConstantUtility.isReturn(r) && !ConstantUtility.isNewLine(r));
                            if (StringJSONReader.this.index >= StringJSONReader.this.length) {
                                r = -1;
                            }
                        } else {
                            StringJSONReader.this.peekRead = pr;
                            break;
                        }
                    }
                    if (ConstantUtility.isReturn(r)) {
                        StringJSONReader.this.handleNewLine();
                        if (StringJSONReader.this.index >= StringJSONReader.this.length) break;
                        if (ConstantUtility.isNewLine(r = (int)StringJSONReader.this.jsonString.charAt(StringJSONReader.this.index++)) && StringJSONReader.this.index < StringJSONReader.this.length) {
                            r = StringJSONReader.this.jsonString.charAt(StringJSONReader.this.index++);
                        }
                    }
                    if (ConstantUtility.isNewLine(r)) {
                        StringJSONReader.this.handleNewLine();
                        if (StringJSONReader.this.index < StringJSONReader.this.length) {
                            r = StringJSONReader.this.jsonString.charAt(StringJSONReader.this.index++);
                        }
                    }
                    if (ConstantUtility.isComment(r)) {
                        StringJSONReader.this.peekRead = r;
                        continue;
                    }
                    if (ConstantUtility.isReturn(r) || ConstantUtility.isNewLine(r)) continue;
                }
                if (ConstantUtility.isReturn(r) || ConstantUtility.isNewLine(r)) {
                    r = -1;
                }
            } else {
                r = -1;
            }
            return r;
        }

        @Override
        public Position getPosition() {
            return StringJSONReader.this.getPosition();
        }

        @Override
        public boolean isHasPeeked() {
            return StringJSONReader.this.isHasPeeked();
        }

        @Override
        public boolean hasPeeked() {
            return StringJSONReader.this.hasPeeked();
        }

        @Override
        public void setHasPeeked(boolean hasPeeked) {
            StringJSONReader.this.setHasPeeked(hasPeeked);
        }

        @Override
        public int getLineNumber() {
            return StringJSONReader.this.getLineNumber();
        }

        @Override
        public int getPositionNumber() {
            return StringJSONReader.this.getPositionNumber();
        }

        @Override
        public JSONReader getStringReader(JSONReader.Mode mode) {
            return this;
        }
    }
}

