/*
 * Decompiled with CFR 0.152.
 */
package jsonij.parser;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import jsonij.ConstantUtility;
import jsonij.Constants;
import jsonij.JSON;
import jsonij.Value;
import jsonij.parser.JSONParserException;
import jsonij.parser.JSONReader;
import jsonij.parser.Parser;
import jsonij.parser.ParserException;
import jsonij.parser.ReaderJSONReader;
import jsonij.parser.StringJSONReader;

public class JSONParser
implements Parser {
    private Dialect dialect = Dialect.FLEXIBLE_RFC_4627;
    private int currentDocument = 0;
    private JSONReader target = null;
    private StringBuilder numericStringBuilder = null;

    public JSONParser() {
    }

    public JSONParser(String inputString) {
        this();
        this.target = new StringJSONReader(inputString);
    }

    public JSONParser(StringJSONReader target) {
        this();
        this.target = target;
    }

    public JSONParser(InputStream inputStream) {
        this(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public JSONParser(Reader inputReader) {
        this();
        this.target = new ReaderJSONReader(inputReader);
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public boolean canParse() throws ParserException {
        return this.target != null && this.target.peek() != -1;
    }

    @Override
    public int currentDocument() {
        return this.currentDocument;
    }

    @Override
    public Value parse() throws ParserException {
        Value value;
        int r = this.target.peek();
        if (r == -1) {
            return null;
        }
        switch (r) {
            case 123: {
                value = this.parseObject();
                break;
            }
            case 91: {
                value = this.parseArray();
                break;
            }
            default: {
                value = this.parseValue();
            }
        }
        ++this.currentDocument;
        return value;
    }

    @Override
    public Value parse(int i) throws ParserException {
        if (i < this.currentDocument) {
            throw new JSONParserException("Attempt to read a JSONParser Backwards.");
        }
        int skipCount = i - this.currentDocument - 1;
        for (int j = 0; j < skipCount; ++j) {
            this.parse();
        }
        return this.parse();
    }

    public final Value parse(String targetString) throws ParserException {
        this.currentDocument = 0;
        this.target = new StringJSONReader(targetString);
        return this.parse();
    }

    public final Value parse(Reader targetReader) throws ParserException {
        this.currentDocument = 0;
        this.target = new ReaderJSONReader(targetReader);
        return this.parse();
    }

    public final Value parseValue() throws ParserException {
        Value value = null;
        int p = this.target.peek();
        if (this.dialect == Dialect.STRICT_RFC_4627 && p == 34) {
            value = this.parseString();
        } else if (this.dialect == Dialect.FLEXIBLE_RFC_4627 && (p == 34 || p == 39)) {
            value = this.parseFlexibleString(new int[0]);
        } else if (p == 123) {
            value = this.parseObject();
        } else if (p == 91) {
            value = this.parseArray();
        } else if (ConstantUtility.isNumeric(p)) {
            value = this.parseNumeric();
        } else if (p == "true".charAt(0)) {
            value = this.parseTrue();
        } else if (p == "false".charAt(0)) {
            value = this.parseFalse();
        } else if (p == "null".charAt(0)) {
            value = this.parseNull();
        } else {
            throw new JSONParserException("invalidUnexpected", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf((char)this.target.peek())});
        }
        return value;
    }

    public final Value parseValue(int ... terminators) throws ParserException {
        Value value = null;
        int p = this.target.peek();
        if (this.dialect == Dialect.STRICT_RFC_4627 && p == 34) {
            value = this.parseString();
        } else if (this.dialect == Dialect.FLEXIBLE_RFC_4627 && (p == 34 || p == 39)) {
            value = this.parseFlexibleString(new int[0]);
        } else if (p == 123) {
            value = this.parseObject();
        } else if (p == 91) {
            value = this.parseArray();
        } else if (ConstantUtility.isNumeric(p)) {
            value = this.parseNumeric();
        } else if (p == "true".charAt(0)) {
            value = this.parseTrue();
        } else if (p == "false".charAt(0)) {
            value = this.parseFalse();
        } else if (p == "null".charAt(0)) {
            value = this.parseNull();
        } else if (terminators != null) {
            value = this.parseFlexibleString(terminators);
        } else {
            throw new JSONParserException("invalidUnexpected", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf((char)this.target.peek())});
        }
        return value;
    }

    public final JSON.Object<JSON.String, Value> parseObject() throws ParserException {
        if (this.target.peek() != 123) {
            throw new JSONParserException("invalidObjectExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf('{'), Character.valueOf((char)this.target.peek())});
        }
        this.target.read();
        JSON.Object<JSON.String, Value> value = new JSON.Object<JSON.String, Value>();
        if (this.target.peek() != 125) {
            JSON.String attributeName = this.dialect != Dialect.STRICT_RFC_4627 ? this.parseFlexibleString(58) : this.parseString();
            if (this.target.peek() != 58) {
                throw new JSONParserException("invalidObjectExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf(':'), Character.valueOf((char)this.target.peek())});
            }
            this.target.read();
            Value attributeValue = this.dialect != Dialect.STRICT_RFC_4627 ? this.parseValue(Constants.OBJECT_KEY_VALUE_TERMINALS) : this.parseValue();
            value.put(attributeName, attributeValue);
            while (this.target.peek() == 44) {
                this.target.read();
                attributeName = this.dialect != Dialect.STRICT_RFC_4627 ? this.parseFlexibleString(58) : this.parseString();
                if (value.containsKey(attributeName)) {
                    throw new JSONParserException("invalidKeyAlreadyUsed", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{attributeName});
                }
                if (this.target.peek() != 58) {
                    throw new JSONParserException("invalidObjectExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf(':'), Character.valueOf((char)this.target.peek())});
                }
                this.target.read();
                attributeValue = this.dialect != Dialect.STRICT_RFC_4627 ? this.parseValue(Constants.ARRAY_KEY_VALUE_TERMINALS) : this.parseValue();
                value.put(attributeName, attributeValue);
            }
        }
        if (this.target.peek() != 125) {
            throw new JSONParserException("invalidArrayExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf('}'), Character.valueOf((char)this.target.peek())});
        }
        this.target.read();
        return value;
    }

    public final JSON.Array<Value> parseArray() throws ParserException {
        if (this.target.peek() != 91) {
            throw new JSONParserException("invalidArrayExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf('['), Character.valueOf((char)this.target.peek())});
        }
        this.target.read();
        JSON.Array<Value> value = new JSON.Array<Value>();
        if (this.target.peek() != 93) {
            Value arrayValue = this.dialect != Dialect.STRICT_RFC_4627 ? this.parseValue(Constants.ARRAY_KEY_VALUE_TERMINALS) : this.parseValue();
            value.add(arrayValue);
            while (this.target.peek() == 44) {
                this.target.read();
                arrayValue = this.parseValue();
                value.add(arrayValue);
            }
        }
        if (this.target.peek() != 93) {
            throw new JSONParserException("invalidArrayExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)this.target.peek())});
        }
        this.target.read();
        return value;
    }

    public final JSON.String parseString() throws ParserException {
        int p;
        if (this.target.peek() != 34) {
            throw new JSONParserException("invalidStringExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf('\"'), Character.valueOf((char)this.target.peek())});
        }
        StringBuilder valueStringBuilder = new StringBuilder();
        JSONReader targetString = this.target.getStringReader(JSONReader.Mode.QUOTED_READING);
        targetString.read();
        block11: while ((p = targetString.peek()) != 34) {
            if (p == 92) {
                targetString.read();
                p = targetString.peek();
                switch (p) {
                    case 34: {
                        valueStringBuilder.append('\"');
                        targetString.read();
                        continue block11;
                    }
                    case 92: {
                        valueStringBuilder.append('\\');
                        targetString.read();
                        continue block11;
                    }
                    case 47: {
                        valueStringBuilder.append('/');
                        targetString.read();
                        continue block11;
                    }
                    case 98: {
                        valueStringBuilder.append('\b');
                        targetString.read();
                        continue block11;
                    }
                    case 102: {
                        valueStringBuilder.append('\f');
                        targetString.read();
                        continue block11;
                    }
                    case 110: {
                        valueStringBuilder.append('\n');
                        targetString.read();
                        continue block11;
                    }
                    case 114: {
                        valueStringBuilder.append('\r');
                        targetString.read();
                        continue block11;
                    }
                    case 116: {
                        valueStringBuilder.append('\t');
                        targetString.read();
                        continue block11;
                    }
                    case 117: {
                        targetString.read();
                        StringBuilder unicodeStringBuilder = new StringBuilder();
                        for (int i = 0; i < 4; ++i) {
                            if (!ConstantUtility.isHexDigit(targetString.peek())) {
                                throw new JSONParserException("invalidStringHex", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek()});
                            }
                            unicodeStringBuilder.append((char)targetString.read());
                        }
                        int unicodeInt = Integer.parseInt(unicodeStringBuilder.toString().toUpperCase(), 16);
                        if (Character.isHighSurrogate((char)unicodeInt)) {
                            String highSurrogateString = unicodeStringBuilder.toString();
                            int highSurrogate = unicodeInt;
                            unicodeStringBuilder = new StringBuilder();
                            if (targetString.peek() != 92) {
                                throw new JSONParserException("invalidStringMissingSurrogate", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{92, targetString.peek()});
                            }
                            targetString.read();
                            if (targetString.peek() != 117) {
                                throw new JSONParserException("invalidStringMissingSurrogate", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{117, targetString.peek()});
                            }
                            targetString.read();
                            for (int i = 0; i < 4; ++i) {
                                if (!ConstantUtility.isHexDigit(targetString.peek())) {
                                    throw new JSONParserException("invalidStringHex", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek()});
                                }
                                unicodeStringBuilder.append((char)targetString.read());
                            }
                            String lowSurrogateString = unicodeStringBuilder.toString();
                            int lowSurrogate = Integer.parseInt(lowSurrogateString.toUpperCase(), 16);
                            if (Character.isSurrogatePair((char)highSurrogate, (char)lowSurrogate)) {
                                char[] c = Character.toChars(Character.toCodePoint((char)highSurrogate, (char)lowSurrogate));
                                valueStringBuilder.append(new String(c));
                                continue block11;
                            }
                            throw new JSONParserException("invalidStringSurrogates", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{highSurrogateString, lowSurrogateString});
                        }
                        if (ConstantUtility.isValidStringChar(unicodeInt)) {
                            valueStringBuilder.append((char)unicodeInt);
                            continue block11;
                        }
                        throw new JSONParserException("invalidStringValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{unicodeInt, unicodeStringBuilder.toString()});
                    }
                }
                throw new JSONParserException("invalidStringEscape", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek()});
            }
            if (ConstantUtility.isValidStringChar(p)) {
                valueStringBuilder.append((char)targetString.read());
                continue;
            }
            throw new JSONParserException("invalidStringValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek(), Character.valueOf((char)targetString.peek())});
        }
        if (targetString.peek() != 34) {
            throw new JSONParserException("invalidStringExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf('\"'), Character.valueOf((char)targetString.peek())});
        }
        targetString.read();
        targetString.close();
        JSON.String value = new JSON.String(valueStringBuilder.toString());
        return value;
    }

    public final JSON.String parseFlexibleString(int ... terminals) throws ParserException {
        JSON.String value;
        JSONReader targetString;
        int quotation;
        StringBuilder valueStringBuilder;
        block26: {
            valueStringBuilder = new StringBuilder();
            quotation = -1;
            if (this.target.peek() == 34 || this.target.peek() == 39) {
                quotation = this.target.read();
                targetString = this.target.getStringReader(JSONReader.Mode.QUOTED_READING);
            } else {
                targetString = this.target.getStringReader(JSONReader.Mode.UN_QUOTED_READING);
            }
            block11: while (true) {
                int p = targetString.peek();
                if (quotation != -1 && p == quotation || this.terminalFound(p, terminals)) break block26;
                if (p == 92) {
                    targetString.read();
                    p = targetString.peek();
                    switch (p) {
                        case 34: {
                            valueStringBuilder.append('\"');
                            targetString.read();
                            continue block11;
                        }
                        case 92: {
                            valueStringBuilder.append('\\');
                            targetString.read();
                            continue block11;
                        }
                        case 47: {
                            valueStringBuilder.append('/');
                            targetString.read();
                            continue block11;
                        }
                        case 98: {
                            valueStringBuilder.append('\b');
                            targetString.read();
                            continue block11;
                        }
                        case 102: {
                            valueStringBuilder.append('\f');
                            targetString.read();
                            continue block11;
                        }
                        case 110: {
                            valueStringBuilder.append('\n');
                            targetString.read();
                            continue block11;
                        }
                        case 114: {
                            valueStringBuilder.append('\r');
                            targetString.read();
                            continue block11;
                        }
                        case 116: {
                            valueStringBuilder.append('\t');
                            targetString.read();
                            continue block11;
                        }
                        case 117: {
                            targetString.read();
                            StringBuilder unicodeStringBuilder = new StringBuilder();
                            for (int i = 0; i < 4; ++i) {
                                if (!ConstantUtility.isHexDigit(targetString.peek())) {
                                    throw new JSONParserException("invalidStringHex", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek()});
                                }
                                unicodeStringBuilder.append((char)targetString.read());
                            }
                            int unicodeInt = Integer.parseInt(unicodeStringBuilder.toString().toUpperCase(), 16);
                            if (Character.isHighSurrogate((char)unicodeInt)) {
                                String highSurrogateString = unicodeStringBuilder.toString();
                                int highSurrogate = unicodeInt;
                                unicodeStringBuilder = new StringBuilder();
                                if (targetString.peek() != 92) {
                                    throw new JSONParserException("invalidStringMissingSurrogate", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{92, targetString.peek()});
                                }
                                targetString.read();
                                if (targetString.peek() != 117) {
                                    throw new JSONParserException("invalidStringMissingSurrogate", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{117, targetString.peek()});
                                }
                                targetString.read();
                                for (int i = 0; i < 4; ++i) {
                                    if (!ConstantUtility.isHexDigit(targetString.peek())) {
                                        throw new JSONParserException("invalidStringHex", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek()});
                                    }
                                    unicodeStringBuilder.append((char)targetString.read());
                                }
                                String lowSurrogateString = unicodeStringBuilder.toString();
                                int lowSurrogate = Integer.parseInt(lowSurrogateString.toUpperCase(), 16);
                                if (Character.isSurrogatePair((char)highSurrogate, (char)lowSurrogate)) {
                                    char[] c = Character.toChars(Character.toCodePoint((char)highSurrogate, (char)lowSurrogate));
                                    valueStringBuilder.append(new String(c));
                                    continue block11;
                                }
                                throw new JSONParserException("invalidStringSurrogates", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{highSurrogateString, lowSurrogateString});
                            }
                            if (ConstantUtility.isValidStringChar(unicodeInt)) {
                                valueStringBuilder.append((char)unicodeInt);
                                continue block11;
                            }
                            throw new JSONParserException("invalidStringValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{unicodeInt, unicodeStringBuilder.toString()});
                        }
                    }
                    throw new JSONParserException("invalidStringEscape", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek()});
                }
                if (!ConstantUtility.isValidStringChar(p) && !ConstantUtility.isWhiteSpace(p) && (this.dialect != Dialect.FLEXIBLE_RFC_4627 || quotation == -1 || quotation == p)) break;
                valueStringBuilder.append((char)targetString.read());
            }
            throw new JSONParserException("invalidStringValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek(), Character.valueOf((char)targetString.peek())});
        }
        if (quotation != -1 && this.target.peek() == quotation) {
            targetString.read();
            value = new JSON.String(valueStringBuilder.toString());
        } else {
            value = new JSON.String(valueStringBuilder.toString().trim());
        }
        return value;
    }

    private boolean terminalFound(int p, int[] terminals) {
        if (terminals != null && terminals.length > 0) {
            for (int i = 0; i < terminals.length; ++i) {
                if (p != terminals[i]) continue;
                return true;
            }
        }
        return false;
    }

    public final JSON.Numeric parseNumeric() throws ParserException {
        this.numericStringBuilder = new StringBuilder();
        boolean minusFlag = false;
        boolean decimalFlag = false;
        boolean exponetFlag = false;
        int s = 0;
        if (this.target.peek() == 45) {
            minusFlag = true;
            this.target.read();
            this.numericStringBuilder.append('-');
            if (this.target.peek() < Constants.DIGITS[0] || this.target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf((char)this.target.peek())});
            }
        }
        if (this.target.peek() == Constants.DIGITS[0]) {
            this.numericStringBuilder.append((char)this.target.read());
            ++s;
        } else if (this.target.peek() >= Constants.DIGITS[1] && this.target.peek() <= Constants.DIGITS[9]) {
            this.numericStringBuilder.append((char)this.target.read());
            ++s;
            while (ConstantUtility.isDigit(this.target.peek())) {
                this.numericStringBuilder.append((char)this.target.read());
                ++s;
            }
        } else {
            throw new JSONParserException("invalidNumericExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf((char)this.target.peek())});
        }
        if (this.target.peek() == 46) {
            this.target.read();
            decimalFlag = true;
            this.numericStringBuilder.append('.');
            if (this.target.peek() < Constants.DIGITS[0] || this.target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf((char)this.target.peek())});
            }
            while (ConstantUtility.isDigit(this.target.peek())) {
                this.numericStringBuilder.append((char)this.target.read());
                ++s;
            }
        }
        if (this.target.peek() == Constants.EXPS[0] || this.target.peek() == Constants.EXPS[1]) {
            this.target.read();
            exponetFlag = true;
            this.numericStringBuilder.append(Constants.EXPS[1]);
            switch (this.target.peek()) {
                case 45: {
                    this.target.read();
                    this.numericStringBuilder.append('-');
                    break;
                }
                case 43: {
                    this.target.read();
                    this.numericStringBuilder.append('+');
                    break;
                }
                default: {
                    this.numericStringBuilder.append('+');
                }
            }
            if (this.target.peek() < Constants.DIGITS[0] || this.target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf((char)this.target.peek())});
            }
            while (ConstantUtility.isDigit(this.target.peek())) {
                this.numericStringBuilder.append((char)this.target.read());
            }
        }
        String numericString = this.numericStringBuilder.toString();
        JSON.Numeric value = !decimalFlag && !exponetFlag ? (s < 10 ? new JSON.Numeric(Integer.parseInt(numericString)) : (s < 18 ? new JSON.Numeric(Long.parseLong(numericString)) : new JSON.Numeric(numericString))) : (s < 10 ? new JSON.Numeric(Float.parseFloat(numericString)) : (s < 16 ? new JSON.Numeric(Double.parseDouble(numericString)) : new JSON.Numeric(numericString)));
        return value;
    }

    public final JSON.True parseTrue() throws ParserException {
        for (int i = 0; i < "true".length(); ++i) {
            if (this.target.peek() != "true".charAt(i)) {
                throw new JSONParserException("invalidValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{"true", Character.valueOf((char)this.target.peek())});
            }
            this.target.read();
        }
        return JSON.TRUE;
    }

    public final JSON.False parseFalse() throws ParserException {
        for (int i = 0; i < "false".length(); ++i) {
            if (this.target.peek() != "false".charAt(i)) {
                throw new JSONParserException("invalidValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{"false", Character.valueOf((char)this.target.peek())});
            }
            this.target.read();
        }
        return JSON.FALSE;
    }

    public final JSON.Null parseNull() throws ParserException {
        for (int i = 0; i < "null".length(); ++i) {
            if (this.target.peek() != "null".charAt(i)) {
                throw new JSONParserException("invalidValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{"null", Character.valueOf((char)this.target.peek())});
            }
            this.target.read();
        }
        return JSON.NULL;
    }

    public static enum Dialect {
        STRICT_RFC_4627,
        FLEXIBLE_RFC_4627;

    }
}

