/*
 * Decompiled with CFR 0.152.
 */
package jsonij.parser;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import jsonij.BSON;
import jsonij.BSONCodec;
import jsonij.JSON;
import jsonij.Value;
import jsonij.parser.BSONParserException;
import jsonij.parser.Parser;
import jsonij.parser.ParserException;

public class BSONParser
implements Parser {
    private final BSONCodec bsonCodec = BSON.CODEC;
    private InputStream inputStream;
    private DataInputStream dataInputStream;
    private int index;
    private final byte[] buffer;

    public BSONParser(InputStream inputStream) {
        this.inputStream = inputStream;
        this.index = 0;
        this.dataInputStream = new DataInputStream(inputStream);
        this.buffer = new byte[8];
    }

    @Override
    public boolean canParse() throws ParserException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int currentDocument() {
        return this.index;
    }

    public void resetDocument(InputStream inputStream) throws IOException {
        this.dataInputStream.close();
        this.inputStream = inputStream;
        this.index = 0;
        this.dataInputStream = new DataInputStream(inputStream);
    }

    private int readLittleInt() throws IOException {
        this.dataInputStream.readFully(this.buffer, 0, 4);
        return this.buffer[3] << 24 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    @Override
    public JSON.Object<String, Value> parse() throws ParserException {
        try {
            int byteCount = this.readLittleInt();
            ByteBuffer byteBuffer = BSON.allocateBuffer(byteCount);
            byteBuffer.putInt(byteCount);
            for (int i = 4; i < byteCount; ++i) {
                byteBuffer.put(this.dataInputStream.readByte());
            }
            byteBuffer.flip();
            byteBuffer.position(4);
            JSON.Object<String, Value> returnObject = new JSON.Object<String, Value>();
            byte element = byteBuffer.get();
            while (element != 0) {
                String elementKey = this.parseBSONElement(byteBuffer);
                Value elementValue = this.parseValue(element, byteBuffer);
                if (elementKey == null || elementValue == null) {
                    // empty if block
                }
                returnObject.put(elementKey, elementValue);
                element = byteBuffer.get();
            }
            ++this.index;
            return returnObject;
        }
        catch (IOException ex) {
            throw new BSONParserException(ex);
        }
    }

    @Override
    public JSON.Object<String, Value> parse(int n) throws ParserException {
        if (n < this.index) {
            throw new BSONParserException("Attempt to read a BSONParser Backwards.");
        }
        int skipCount = n - this.index - 1;
        for (int i = 0; i < skipCount; ++i) {
            try {
                int byteCount = this.readLittleInt();
                this.dataInputStream.skip(byteCount - 4);
                ++this.index;
                continue;
            }
            catch (IOException ex) {
                throw new BSONParserException(ex);
            }
        }
        return this.parse();
    }

    private Value parseValue(byte element, ByteBuffer byteBuffer) throws IOException {
        Value elementValue;
        switch (element) {
            case 8: {
                elementValue = this.parseBSONBoolean(byteBuffer);
                break;
            }
            case 7: {
                elementValue = this.parseBSONObjectID(byteBuffer);
                break;
            }
            case 1: {
                elementValue = this.parseBSONDouble(byteBuffer);
                break;
            }
            case 2: {
                elementValue = this.parseBSONString(byteBuffer);
                break;
            }
            case 10: {
                elementValue = BSON.NULL;
                break;
            }
            case 4: {
                elementValue = this.parseBSONArray(byteBuffer);
                break;
            }
            case 3: {
                elementValue = this.parseBSONDocument(byteBuffer);
                break;
            }
            case 17: {
                elementValue = this.parseBSONTimestamp(byteBuffer);
                break;
            }
            case 16: {
                elementValue = this.parseBSONInt32(byteBuffer);
                break;
            }
            case 18: {
                elementValue = this.parseBSONInt64(byteBuffer);
                break;
            }
            case 9: {
                elementValue = this.parseBSONUTCDateTime(byteBuffer);
                break;
            }
            case 13: {
                elementValue = this.parseBSONJS(byteBuffer);
                break;
            }
            case 15: {
                elementValue = this.parseBSONJSWithScope(byteBuffer);
                break;
            }
            case 11: {
                elementValue = this.parseBSONRegex(byteBuffer);
                break;
            }
            case 5: {
                elementValue = this.parseBSONBinaryData(byteBuffer);
                break;
            }
            case 12: {
                elementValue = this.parseBSONDBPointer(byteBuffer);
                break;
            }
            case 127: {
                elementValue = this.parseBSONMaxKey(byteBuffer);
                break;
            }
            case -1: {
                elementValue = this.parseBSONMinKey(byteBuffer);
                break;
            }
            case 6: {
                elementValue = this.parseBSONUndefined1(byteBuffer);
                break;
            }
            case 14: {
                elementValue = this.parseBSONUndefined2(byteBuffer);
                break;
            }
            default: {
                System.out.println("Unknown Element: " + Integer.toHexString(element));
                elementValue = BSON.NULL;
            }
        }
        return elementValue;
    }

    private String parseBSONElement(ByteBuffer byteBuffer) {
        return this.bsonCodec.decodeCString(byteBuffer);
    }

    private JSON.Boolean parseBSONBoolean(ByteBuffer byteBuffer) {
        return this.bsonCodec.decodeBSONBoolean(byteBuffer) ? BSON.TRUE : BSON.FALSE;
    }

    private BSON.ObjectID parseBSONObjectID(ByteBuffer byteBuffer) throws IOException {
        byte[] objectIDBytes = new byte[12];
        byteBuffer.get(objectIDBytes);
        return new BSON.ObjectID(this.bsonCodec.decodeObjectID(objectIDBytes));
    }

    private JSON.Numeric parseBSONDouble(ByteBuffer byteBuffer) {
        return new JSON.Numeric(this.bsonCodec.decodeDouble(byteBuffer));
    }

    private JSON.String parseBSONString(ByteBuffer byteBuffer) {
        return new JSON.String(this.bsonCodec.decodeUTF8String(byteBuffer));
    }

    private Value parseBSONArray(ByteBuffer byteBuffer) throws IOException {
        int byteCount = byteBuffer.getInt();
        JSON.Array<Value> array = new JSON.Array<Value>();
        byte element = byteBuffer.get();
        while (element != 0) {
            String elementKey = this.parseBSONElement(byteBuffer);
            Value elementValue = this.parseValue(element, byteBuffer);
            array.add(elementValue);
            element = byteBuffer.get();
        }
        return array;
    }

    private JSON.Object<?, ?> parseBSONDocument(ByteBuffer byteBuffer) throws IOException {
        int byteSize = byteBuffer.getInt();
        JSON.Object returnObject = new JSON.Object();
        byte element = byteBuffer.get();
        while (element != 0) {
            String elementKey = this.parseBSONElement(byteBuffer);
            Value elementValue = this.parseValue(element, byteBuffer);
            if (elementKey == null || elementValue == null) {
                // empty if block
            }
            returnObject.put(elementKey, elementValue);
            element = byteBuffer.get();
        }
        return returnObject;
    }

    private BSON.Timestamp parseBSONTimestamp(ByteBuffer byteBuffer) {
        return new BSON.Timestamp(this.bsonCodec.decodeTimestamp(byteBuffer));
    }

    private BSON.Int32 parseBSONInt32(ByteBuffer byteBuffer) {
        return new BSON.Int32(this.bsonCodec.decodeInt32(byteBuffer));
    }

    private BSON.Int64 parseBSONInt64(ByteBuffer byteBuffer) {
        return new BSON.Int64(this.bsonCodec.decodeInt64(byteBuffer));
    }

    private BSON.UTCDateTime parseBSONUTCDateTime(ByteBuffer byteBuffer) {
        return new BSON.UTCDateTime(this.bsonCodec.decodeUTCDateTime(byteBuffer));
    }

    private BSON.JavaScript parseBSONJS(ByteBuffer byteBuffer) {
        return new BSON.JavaScript(this.bsonCodec.decodeUTF8String(byteBuffer));
    }

    private BSON.JavaScriptWithScope parseBSONJSWithScope(ByteBuffer byteBuffer) throws IOException {
        return new BSON.JavaScriptWithScope(this.bsonCodec.decodeUTF8String(byteBuffer), this.parseBSONDocument(byteBuffer));
    }

    private Value parseBSONRegex(ByteBuffer byteBuffer) {
        return new BSON.RegularExpression(this.bsonCodec.decodeCString(byteBuffer), this.bsonCodec.decodeCString(byteBuffer));
    }

    private Value parseBSONBinaryData(ByteBuffer byteBuffer) {
        int size = this.bsonCodec.decodeInt32(byteBuffer);
        byte type = byteBuffer.get();
        ByteBuffer payload = byteBuffer.slice();
        return new BSON.BinaryData(size, type, payload);
    }

    private Value parseBSONDBPointer(ByteBuffer byteBuffer) {
        byte[] objectIDBytes = new byte[12];
        byteBuffer.get(objectIDBytes);
        return new BSON.ObjectID(this.bsonCodec.decodeObjectID(objectIDBytes));
    }

    private Value parseBSONMaxKey(ByteBuffer byteBuffer) {
        return BSON.MAX_KEY;
    }

    private Value parseBSONMinKey(ByteBuffer byteBuffer) {
        return BSON.MIN_KEY;
    }

    private Value parseBSONUndefined1(ByteBuffer byteBuffer) {
        return BSON.UNDEFINED_1;
    }

    private Value parseBSONUndefined2(ByteBuffer byteBuffer) {
        String value = this.bsonCodec.decodeUTF8String(byteBuffer);
        return new BSON.Undefined2(value);
    }
}

