/*
 * Decompiled with CFR 0.152.
 */
package jsonij;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import jsonij.BSONCodec;
import jsonij.BSONTimestamp;
import jsonij.Decimal128;
import jsonij.JSON;
import jsonij.ObjectIdentifier;
import jsonij.Value;
import jsonij.ValueType;
import jsonij.parser.BSONParserException;

public class BSON
extends JSON {
    public static BSONCodec CODEC = new BSONCodec();
    public static final MinKey MIN_KEY = new MinKey();
    public static final MinKey MAX_KEY = new MinKey();
    public static final Undefined1 UNDEFINED_1 = new Undefined1();

    public BSON(Value root) {
        super(root);
    }

    public static ByteBuffer allocateBuffer(int size) {
        return BSON.allocateBuffer(size, true);
    }

    public static ByteBuffer allocateBuffer(int size, boolean isDirect) {
        ByteBuffer buffer = isDirect ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    public static void deallocateBuffer(ByteBuffer buffer) {
        buffer.clear();
    }

    public static byte[] hexStringToByteArray(String s) {
        return BSON.hexStringToByteArray(s, true);
    }

    public static byte[] hexStringToByteArray(String s, boolean cleanSpaces) {
        if (cleanSpaces && s.indexOf(32) != -1) {
            s = s.replaceAll(" ", "");
        }
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public ByteBuffer toBSON(ByteBuffer buffer) throws BSONParserException {
        if (this.root.getValueType() != ValueType.OBJECT) {
            throw new BSONParserException("Root type must be OBJECT");
        }
        buffer.rewind();
        return buffer;
    }

    @Override
    public String toString() {
        return "BSON@" + Integer.toHexString(this.hashCode()) + ":" + this.getRoot().toString();
    }

    public static final class DBPointer
    extends Value {
        private static final long serialVersionUID = 8209568600602210064L;
        public ObjectIdentifier objectID;

        public DBPointer(ObjectIdentifier objectID) {
            this.objectID = objectID;
        }

        public ObjectIdentifier getObjectID() {
            return this.objectID;
        }

        public void setObjectID(ObjectIdentifier objectID) {
            this.objectID = objectID;
        }

        @Override
        public ValueType internalType() {
            return ValueType.OBJECT_ID;
        }

        @Override
        public int nestedSize() {
            return 24;
        }

        @Override
        public String toJSON() {
            return String.format("{\"$oid\":\"%s\"}", this.objectID.toString());
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            return buffer.put(this.objectID.getContents());
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class MaxKey
    extends Value {
        private static final long serialVersionUID = -1376756107799927028L;

        @Override
        public ValueType internalType() {
            return ValueType.MAX_KEY;
        }

        @Override
        public int nestedSize() {
            return 0;
        }

        @Override
        public String toJSON() {
            return "\"MaxKey\"";
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            buffer.put((byte)127);
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class MinKey
    extends Value {
        private static final long serialVersionUID = 3379267581398348546L;

        @Override
        public ValueType internalType() {
            return ValueType.MIN_KEY;
        }

        @Override
        public int nestedSize() {
            return 0;
        }

        @Override
        public String toJSON() {
            return "\"MinKey\"";
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            buffer.put((byte)-1);
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Undefined2
    extends Value {
        private static final long serialVersionUID = -144895138458224358L;
        String value;

        public Undefined2(String value) {
            this.value = value;
        }

        @Override
        public ValueType internalType() {
            return ValueType.UNDEFINED_2;
        }

        @Override
        public int nestedSize() {
            return 1;
        }

        @Override
        public String toJSON() {
            return "\"Undefined_2\\" + this.value + "\"";
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            buffer.put((byte)14);
            CODEC.encodeUTF8String(buffer, this.value);
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Undefined1
    extends Value {
        private static final long serialVersionUID = -7698699876171548324L;

        @Override
        public ValueType internalType() {
            return ValueType.UNDEFINED_1;
        }

        @Override
        public int nestedSize() {
            return 1;
        }

        @Override
        public String toJSON() {
            return "\"Undefined_1\"";
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            buffer.put((byte)6);
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static class BinaryData
    extends Value {
        private static final long serialVersionUID = -470686043986109846L;
        int size;
        byte type;
        ByteBuffer data;

        public BinaryData(int size, byte type, ByteBuffer data) {
            this.size = size;
            this.type = type;
            this.data = data;
        }

        @Override
        public ValueType internalType() {
            return ValueType.BINARY_DATA;
        }

        @Override
        public int nestedSize() {
            return this.size + 1;
        }

        @Override
        public String toJSON() {
            return String.format("{\"$tp\":\"%s\",\"$s\":%s,\"$d\":[]}", this.type, this.size);
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            return CODEC.encodeBinaryData(buffer, this);
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Timestamp
    extends Value {
        private static final long serialVersionUID = -7905721243903837708L;
        BSONTimestamp timestamp;

        public Timestamp(BSONTimestamp timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public ValueType internalType() {
            return ValueType.TIMESTAMP;
        }

        @Override
        public int nestedSize() {
            return 1;
        }

        @Override
        public String toJSON() {
            return String.format("{\"$timestamp\":{\"t\":%s,\"i\":%s}}", this.timestamp.getTime(), this.timestamp.getIncrement());
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            return CODEC.encodeTimestamp(buffer, this.timestamp);
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Decimal
    extends Value {
        private static final long serialVersionUID = -150426236159560887L;
        Decimal128 decimal128;

        public Decimal(Decimal128 decimal128) {
            this.decimal128 = decimal128;
        }

        @Override
        public ValueType internalType() {
            return ValueType.DECIMAL128;
        }

        @Override
        public int nestedSize() {
            return 1;
        }

        @Override
        public String toJSON() {
            return String.format("{\"$numberDecimal\":\"%s\"}", this.decimal128.toString());
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            CODEC.encodeDecimal128(buffer, this);
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Int64
    extends Value {
        private static final long serialVersionUID = -150426236159560886L;
        long int64;

        public Int64(long int64) {
            this.int64 = int64;
        }

        @Override
        public ValueType internalType() {
            return ValueType.INT64;
        }

        @Override
        public int nestedSize() {
            return 1;
        }

        @Override
        public String toJSON() {
            return String.format("{\"$numberLong\":\"%s\"}", this.int64);
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            CODEC.encodeInt64(buffer, this.int64);
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Int32
    extends Value {
        private static final long serialVersionUID = -8623259974661974258L;
        int int32;

        public Int32(int int32) {
            this.int32 = int32;
        }

        @Override
        public ValueType internalType() {
            return ValueType.INT32;
        }

        @Override
        public int nestedSize() {
            return 1;
        }

        @Override
        public String toJSON() {
            return "" + this.int32;
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            CODEC.encodeInt32(buffer, this.int32);
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class UTCDateTime
    extends Value {
        private static final long serialVersionUID = -331695384446895828L;
        Date date;

        public UTCDateTime(long dateTime) {
            this.date = new Date(dateTime);
        }

        @Override
        public ValueType internalType() {
            return ValueType.UTC_DATE_TIME;
        }

        @Override
        public int nestedSize() {
            return 1;
        }

        @Override
        public String toJSON() {
            return this.date != null ? String.format("\"%s\"", ObjectIdentifier.ISO8601_FORMAT.format(this.date)) : "null";
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            CODEC.encodeUTCDateTime(buffer, this.date.getTime());
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class JavaScriptWithScope
    extends Value {
        private static final long serialVersionUID = 3715743229597512644L;
        String jsCode;
        JSON.Object<?, ?> document;

        public JavaScriptWithScope(String jsCode, JSON.Object<?, ?> document) {
            this.jsCode = jsCode;
            this.document = document;
        }

        @Override
        public ValueType internalType() {
            return ValueType.JAVA_SCRIPT_CODE_WS;
        }

        @Override
        public int nestedSize() {
            return 5 + this.jsCode.length() + this.document.nestedSize();
        }

        @Override
        public String toJSON() {
            return String.format("{\"$js\":\"%s\", \"$doc\":\"%s\"}", this.jsCode, this.document.toJSON());
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            CODEC.encodeCString(buffer, this.jsCode);
            this.document.toBSON(buffer);
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class RegularExpression
    extends Value {
        private static final long serialVersionUID = 6905337153787601861L;
        String expression;
        String options;

        public RegularExpression(String expression, String options) {
            this.expression = expression;
            this.options = options;
        }

        @Override
        public ValueType internalType() {
            return ValueType.REGEX;
        }

        @Override
        public int nestedSize() {
            return 1 + this.expression.length() + 1 + (this.options != null ? this.options.length() : 0);
        }

        @Override
        public String toJSON() {
            return String.format("{\"$regex\":\"%s\", \"$opt\":\"%s\"}", this.expression, this.options);
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            CODEC.encodeUTF8String(buffer, this.expression);
            CODEC.encodeUTF8String(buffer, this.options);
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class JavaScript
    extends Value {
        private static final long serialVersionUID = 8584810273835952483L;
        String jsCode;

        public JavaScript(String jsCode) {
            this.jsCode = jsCode;
        }

        @Override
        public ValueType internalType() {
            return ValueType.JAVA_SCRIPT_CODE;
        }

        @Override
        public int nestedSize() {
            return 1;
        }

        @Override
        public String toJSON() {
            return String.format("{\"$js\":\"%s\"}", this.jsCode);
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            return CODEC.encodeUTF8String(buffer, this.jsCode);
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ObjectID
    extends Value {
        private static final long serialVersionUID = 2458791087064626114L;
        public ObjectIdentifier objectID;

        public ObjectID(ObjectIdentifier objectID) {
            this.objectID = objectID;
        }

        public ObjectIdentifier getObjectID() {
            return this.objectID;
        }

        public void setObjectID(ObjectIdentifier objectID) {
            this.objectID = objectID;
        }

        @Override
        public ValueType internalType() {
            return ValueType.OBJECT_ID;
        }

        @Override
        public int nestedSize() {
            return 24;
        }

        @Override
        public String toJSON() {
            return String.format("{\"$oid\":\"%s\"}", this.objectID.toString());
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            return buffer.put(this.objectID.getContents());
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }
}

