/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.parser;

import cc.plural.jsonij.parser.ParserException;
import cc.plural.jsonij.parser.Position;
import cc.plural.jsonij.parser.ReaderParser;
import java.io.Reader;

public abstract class BaseReaderParser
implements ReaderParser {
    protected int peekValue = -1;
    protected boolean hasPeeked = false;
    protected Position position = new Position();

    public BaseReaderParser() {
        this(null);
    }

    public BaseReaderParser(Reader reader) {
    }

    public Position getPosition() {
        return this.position;
    }

    protected Position setPosition(Position position) {
        this.position = position;
        return this.position;
    }

    public boolean isHasPeeked() {
        return this.hasPeeked();
    }

    public boolean hasPeeked() {
        return this.hasPeeked;
    }

    public void setHasPeeked(boolean hasPeeked) {
        this.hasPeeked = hasPeeked;
    }

    public int getLineNumber() {
        return this.getPosition().getLineNumber();
    }

    public int getPositionNumber() {
        return this.getPosition().getPostionNumber();
    }

    public int peek() throws ParserException {
        if (!this.hasPeeked) {
            this.peekValue = this.readNext();
            this.hasPeeked = true;
        }
        return this.peekValue;
    }

    public int read() throws ParserException {
        if (this.hasPeeked) {
            this.hasPeeked = false;
            return this.peekValue;
        }
        return this.readNext();
    }

    protected abstract int readNext() throws ParserException;

    public void close() {
    }

    protected void handleNewLine() throws ParserException {
        this.getPosition().newLine();
    }

    public String toString() {
        String state;
        try {
            state = String.format("Next Char %s", Character.valueOf((char)this.peek()));
        }
        catch (ParserException e) {
            state = String.format("Unknown State: %s", e.toString());
        }
        return String.format("Reader %s: %s", this.getPosition(), state);
    }
}

