/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.marshal.codec;

import cc.plural.jsonij.JSON;
import cc.plural.jsonij.Value;
import cc.plural.jsonij.marshal.JSONMarshalerException;
import cc.plural.jsonij.marshal.codec.JSONValueCodec;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateJSONValueCodec
implements JSONValueCodec {
    public static DateFormat ISO8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");

    public static <D extends Date> Value encode(D d) {
        return new JSON.String(ISO8601_FORMAT.format(d));
    }

    public static <D extends Date> D decode(Value value, Class<D> clazz) throws JSONMarshalerException {
        if (value.type() == Value.TYPE.STRING) {
            Date decodedObject = null;
            try {
                decodedObject = (Date)clazz.newInstance();
                Date date = ISO8601_FORMAT.parse(value.getString());
                decodedObject.setTime(date.getTime());
            }
            catch (ParseException ex) {
                Logger.getLogger(DateJSONValueCodec.class.getName()).log(Level.SEVERE, null, ex);
                throw new JSONMarshalerException("decode", new Object[0]);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(DateJSONValueCodec.class.getName()).log(Level.SEVERE, null, ex);
                throw new JSONMarshalerException("decode", new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(DateJSONValueCodec.class.getName()).log(Level.SEVERE, null, ex);
                throw new JSONMarshalerException("decode", new Object[0]);
            }
            return (D)decodedObject;
        }
        throw new JSONMarshalerException("notdate", new Object[0]);
    }
}

