/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.jpath;

import cc.plural.jsonij.Value;
import cc.plural.jsonij.jpath.Component;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyComponent
extends Component {
    String value;

    public KeyComponent(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.format("KeyComponent [%s]", this.value);
    }

    @Override
    public List<Value> evaluate(List<Value> values, List<Value> results) {
        Value valueStore = null;
        for (Value currentValue : values) {
            String keyValue = this.getValue();
            if (currentValue.getValueType() == Value.TYPE.OBJECT) {
                valueStore = currentValue.get(keyValue);
                if (valueStore == null) continue;
                results.add(valueStore);
                continue;
            }
            if (currentValue.getValueType() != Value.TYPE.ARRAY) continue;
            for (int j = 0; j < currentValue.size(); ++j) {
                valueStore = currentValue.get(j).get(keyValue);
                if (valueStore == null) continue;
                results.add(valueStore);
            }
        }
        return results;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyComponent other = (KeyComponent)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }
}

