/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij;

import cc.plural.jsonij.JSON;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Value
implements Serializable,
Comparable<Value> {
    private static final long serialVersionUID = 2774919263250085887L;
    protected TYPE valueType = this.internalType();

    public Value() {
        if (this.valueType == null) {
            throw new NullPointerException("type() method must be implemented and return a valid type.");
        }
    }

    protected abstract TYPE internalType();

    public TYPE getValueType() {
        return this.valueType;
    }

    public TYPE type() {
        return this.valueType;
    }

    public int size() {
        switch (this.valueType) {
            case STRING: {
                return ((JSON.String)this).length();
            }
            case ARRAY: {
                return ((JSON.Array)this).size();
            }
            case OBJECT: {
                return ((JSON.Object)this).size();
            }
        }
        return -1;
    }

    public abstract int nestedSize();

    public boolean isNull() {
        switch (this.valueType) {
            case NULL: {
                return true;
            }
        }
        return !this.getBoolean();
    }

    public boolean getBoolean() {
        boolean result = false;
        switch (this.valueType) {
            case TRUE: {
                result = true;
                break;
            }
            case FALSE: {
                result = false;
                break;
            }
            case NUMERIC: {
                result = ((JSON.Numeric)this).intValue() != 0;
                break;
            }
            case STRING: {
                result = ((JSON.String)this).length() != 0;
                break;
            }
            case ARRAY: {
                result = ((JSON.Array)this).size() != 0;
                break;
            }
            case OBJECT: {
                result = ((JSON.Object)this).size() != 0;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public int getInt() {
        int result = -1;
        switch (this.valueType) {
            case NUMERIC: {
                result = ((JSON.Numeric)this).intValue();
                break;
            }
            case TRUE: {
                result = 1;
                break;
            }
            case FALSE: {
                result = 0;
                break;
            }
            case STRING: {
                result = Integer.parseInt(this.toString());
            }
        }
        return result;
    }

    public double getDouble() {
        double result = -1.0;
        switch (this.valueType) {
            case NUMERIC: {
                result = ((JSON.Numeric)this).doubleValue();
                break;
            }
            case TRUE: {
                result = 1.0;
                break;
            }
            case FALSE: {
                result = 0.0;
                break;
            }
            case STRING: {
                result = Double.parseDouble(this.toString());
            }
        }
        return result;
    }

    public long getLong() {
        long result = -1L;
        switch (this.valueType) {
            case NUMERIC: {
                result = ((JSON.Numeric)this).longValue();
                break;
            }
            case TRUE: {
                result = 1L;
                break;
            }
            case FALSE: {
                result = 0L;
                break;
            }
            case STRING: {
                result = Long.parseLong(this.toString());
            }
        }
        return result;
    }

    public Number getNumber() {
        Number result = -1.0;
        switch (this.valueType) {
            case NUMERIC: {
                result = ((JSON.Numeric)this).getNumber();
                break;
            }
            case TRUE: {
                result = 1.0;
                break;
            }
            case FALSE: {
                result = 0.0;
                break;
            }
            case STRING: {
                result = Double.parseDouble(this.toString());
            }
        }
        return result;
    }

    public String getString() {
        String result = null;
        switch (this.valueType) {
            case STRING: {
                result = this.toString();
                break;
            }
            case TRUE: {
                result = "true";
                break;
            }
            case FALSE: {
                result = "false";
                break;
            }
            case NUMERIC: {
                result = ((JSON.Numeric)this).toString();
                break;
            }
            case OBJECT: {
                result = ((JSON.Object)this).toString();
                break;
            }
            case ARRAY: {
                result = ((JSON.Array)this).toString();
            }
        }
        return result;
    }

    public Value get(int i) {
        Object result = null;
        switch (this.valueType) {
            case ARRAY: {
                result = ((JSON.Array)this).get(i);
                break;
            }
            case OBJECT: {
                result = ((JSON.Object)this).get(i);
            }
        }
        return result;
    }

    public boolean has(String key) {
        boolean result = false;
        switch (this.valueType) {
            case OBJECT: {
                result = ((JSON.Object)this).containsKey(new JSON.String(key));
            }
        }
        return result;
    }

    public Set<CharSequence> valueKeySet() {
        Set keys = null;
        switch (this.valueType) {
            case OBJECT: {
                keys = ((JSON.Object)this).mapValue.keySet();
            }
        }
        return keys;
    }

    public Value get(CharSequence key) {
        Value result = null;
        switch (this.valueType) {
            case OBJECT: {
                result = (Value)((JSON.Object)this).safeGet(key.toString());
            }
        }
        return result;
    }

    public abstract String toJSON();

    public String toString() {
        return this.toJSON();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value o = (Value)obj;
        boolean equalsResult = false;
        if (this.internalType() == TYPE.OBJECT) {
            if (o.internalType() == TYPE.OBJECT) {
                if (o.size() == this.size()) {
                    equalsResult = true;
                    Iterator<CharSequence> keySetIterator = this.valueKeySet().iterator();
                    Value thisValue = null;
                    Value otherValue = null;
                    while (keySetIterator.hasNext()) {
                        CharSequence key = keySetIterator.next();
                        thisValue = this.get(key);
                        otherValue = o.get(key);
                        if (otherValue == null || thisValue.equals(otherValue)) continue;
                        equalsResult = false;
                        break;
                    }
                } else {
                    equalsResult = false;
                }
            } else {
                equalsResult = this.toString().equals(o.toString());
            }
        } else if (this.internalType() == TYPE.ARRAY) {
            if (o.internalType() == TYPE.ARRAY) {
                if (o.size() == this.size()) {
                    equalsResult = true;
                    for (int i = 0; i < this.size(); ++i) {
                        if (this.get(i).equals(o.get(i))) continue;
                        equalsResult = false;
                        break;
                    }
                } else {
                    equalsResult = false;
                }
            } else {
                equalsResult = this.toString().equals(o.toString());
            }
        } else if (this.internalType() == TYPE.NULL) {
            equalsResult = this.isNull() && o.isNull();
        } else if (this.internalType() == TYPE.TRUE || this.internalType() == TYPE.FALSE) {
            equalsResult = this.getBoolean() == o.getBoolean();
        } else if (this.internalType() == TYPE.NUMERIC) {
            Number thisNumber = this.getNumber();
            Number otherNumber = o.getNumber();
            if (thisNumber != null && otherNumber != null) {
                equalsResult = thisNumber.equals(otherNumber);
            }
        } else if (this.internalType() == TYPE.STRING) {
            equalsResult = this.getString().equals(o.getString());
        }
        return equalsResult;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.valueType != null ? this.valueType.hashCode() : 0);
        if (this.internalType() == TYPE.OBJECT) {
            for (int i = 0; i < this.size(); ++i) {
                hash = 13 * hash + this.get(i).hashCode();
            }
        } else if (this.internalType() == TYPE.ARRAY) {
            for (int i = 0; i < this.size(); ++i) {
                hash = 13 * hash + this.get(i).hashCode();
            }
        } else if (this.internalType() == TYPE.NULL) {
            hash = 13 * hash + JSON.NULL.hashCode();
        } else if (this.internalType() == TYPE.TRUE) {
            hash = 13 * hash + JSON.TRUE.hashCode();
        } else if (this.internalType() == TYPE.FALSE) {
            hash = 13 * hash + JSON.FALSE.hashCode();
        } else if (this.internalType() == TYPE.NUMERIC) {
            hash = 13 * hash + this.getNumber().hashCode();
        } else if (this.internalType() == TYPE.STRING) {
            hash = this.getString() != null ? this.getString().hashCode() : 0;
        }
        return hash;
    }

    @Override
    public int compareTo(Value o) {
        int compare = 0;
        if (this.internalType() == TYPE.OBJECT) {
            compare = o.internalType() == TYPE.NULL || o.internalType() == TYPE.TRUE || o.internalType() == TYPE.FALSE ? 1 : this.toJSON().compareTo(o.toJSON());
        } else if (this.internalType() == TYPE.ARRAY) {
            compare = o.internalType() == TYPE.NULL || o.internalType() == TYPE.TRUE || o.internalType() == TYPE.FALSE || o.internalType() == TYPE.OBJECT ? 1 : this.toJSON().compareTo(o.toJSON());
        } else if (this.internalType() == TYPE.NULL) {
            compare = o.internalType() == TYPE.NULL ? 0 : -1;
        } else if (this.internalType() == TYPE.TRUE) {
            compare = o.internalType() == TYPE.NULL ? 1 : (o.internalType() == TYPE.TRUE ? 0 : -1);
        } else if (this.internalType() == TYPE.FALSE) {
            compare = o.internalType() == TYPE.NULL ? 1 : (o.internalType() == TYPE.TRUE ? 1 : (o.internalType() == TYPE.FALSE ? 0 : -1));
        } else if (this.internalType() == TYPE.NUMERIC) {
            double thatDouble;
            double thisDouble = this.getDouble();
            if (thisDouble < (thatDouble = o.getDouble())) {
                compare = -1;
            } else if (thisDouble == thatDouble) {
                compare = 0;
            } else if (thisDouble > thatDouble) {
                compare = 1;
            }
        } else if (this.internalType() == TYPE.STRING) {
            compare = this.getString().compareTo(o.getString());
        }
        return compare;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        OBJECT,
        ARRAY,
        STRING,
        NUMERIC,
        TRUE,
        FALSE,
        NULL;

    }
}

