/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.marshal;

import cc.plural.jsonij.JSON;
import cc.plural.jsonij.Value;
import cc.plural.jsonij.marshal.JSONMarshaler;
import cc.plural.jsonij.marshal.JSONMarshalerException;
import cc.plural.jsonij.marshal.JavaMarshaler;
import cc.plural.jsonij.marshal.annotation.JSONCollector;
import cc.plural.jsonij.marshal.annotation.JSONEncoder;
import cc.plural.jsonij.reflect.ClassProperty;
import cc.plural.jsonij.reflect.Inspection;
import cc.plural.jsonij.reflect.ReflectType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;

public class JavaMarshalerObjects {
    protected JavaMarshaler marshaler;

    public JavaMarshalerObjects(JavaMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public Value marshalJavaObject(Object o, JavaMarshaler.CycleDetector cycleDetector) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, JSONMarshalerException {
        Field[] fields;
        Method[] methods;
        Class<?> objectClass = o.getClass();
        for (Method method : methods = objectClass.getDeclaredMethods()) {
            if (method.getAnnotation(JSONEncoder.class) == null) continue;
        }
        for (Field field : fields = objectClass.getFields()) {
            if (field.getAnnotation(JSONCollector.class) == null) continue;
        }
        Inspection inspection = ReflectType.getInspection(objectClass);
        HashMap<String, Value> valueCollector = new HashMap<String, Value>();
        List<ClassProperty> properties = inspection.getProperties();
        int propCount = 0;
        for (ClassProperty property : properties) {
            Value value;
            block21: {
                ClassProperty.ClassPropertyAccessor accessor = property.getAccessor();
                if (accessor == null || !accessor.canAccess()) continue;
                if (accessor.fieldType()) {
                    try {
                        Field field = property.getAccessor().getField();
                        value = this.marshalObjectFieldValue(field, o, cycleDetector);
                        if (value == null) {
                            continue;
                        }
                        break block21;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        value = new JSON.String(ex.toString());
                        break block21;
                    }
                }
                if (accessor.methodType()) {
                    try {
                        Method method = property.getAccessor().getMethod();
                        value = this.marshalObjectMethodValue(method, o, cycleDetector);
                        if (value == null) {
                            continue;
                        }
                        break block21;
                    }
                    catch (Exception ex) {
                        value = new JSON.String(ex.toString());
                        break block21;
                    }
                }
                value = JSON.NULL;
            }
            ++propCount;
            valueCollector.put(property.getPropertyName(), value);
        }
        if (inspection.hasInnerList()) {
            if (JSONMarshaler.ALWAYS_USE_INNER_PROPERTY || propCount > 0) {
                valueCollector.put(JSONMarshaler.INNER_ARRAY_PROPERTY, this.marshaler.marshalJavaList(o, cycleDetector));
            } else {
                return this.marshaler.marshalJavaList(o, cycleDetector);
            }
        }
        if (inspection.hasInnerMap()) {
            if (JSONMarshaler.ALWAYS_USE_INNER_PROPERTY || propCount > 0) {
                valueCollector.put(JSONMarshaler.INNER_OBJECT_PROPERTY, this.marshaler.marshalJavaMap(o, cycleDetector));
            } else {
                return this.marshaler.marshalJavaMap(o, cycleDetector);
            }
        }
        if (valueCollector.isEmpty()) {
            return null;
        }
        JSON.Object marshaledObject = new JSON.Object();
        for (String key : valueCollector.keySet()) {
            marshaledObject.put(new JSON.String(key), (Value)valueCollector.get(key));
        }
        if (inspection.hasCollectors()) {
            for (ClassProperty collector : inspection.getCollectors()) {
            }
        }
        return marshaledObject;
    }

    protected Value marshalObjectMethodValue(Method method, Object o, JavaMarshaler.CycleDetector cycleDetector) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, JSONMarshalerException {
        Value value;
        Object marshaledObject = method.invoke(o, new Object[0]);
        if (marshaledObject == null) {
            value = null;
        } else {
            int hashCode = marshaledObject.hashCode();
            if (marshaledObject.getClass() == Boolean.class || marshaledObject.getClass() == Byte.class || marshaledObject.getClass() == Short.class || marshaledObject.getClass() == Integer.class || marshaledObject.getClass() == Float.class || marshaledObject.getClass() == Double.class || marshaledObject.getClass() == Long.class || marshaledObject.getClass() == String.class) {
                value = this.marshaler.marshalAnyObject(marshaledObject, cycleDetector.cloneCycleDetector());
            } else if (!cycleDetector.hashDetected(hashCode) || cycleDetector.getHashCount(hashCode) < JSONMarshaler.getCycleLevels()) {
                cycleDetector.addHash(hashCode);
                value = this.marshaler.marshalAnyObject(marshaledObject, cycleDetector.cloneCycleDetector());
            } else {
                value = null;
            }
        }
        return value;
    }

    protected Value marshalObjectFieldValue(Field field, Object o, JavaMarshaler.CycleDetector cycleDetector) throws IllegalArgumentException, IllegalAccessException, JSONMarshalerException {
        Value value = null;
        Object marshaledObject = field.get(o);
        if (marshaledObject == null) {
            value = null;
        } else {
            int hashCode = marshaledObject.hashCode();
            if (marshaledObject.getClass() == Boolean.class || marshaledObject.getClass() == Byte.class || marshaledObject.getClass() == Short.class || marshaledObject.getClass() == Integer.class || marshaledObject.getClass() == Float.class || marshaledObject.getClass() == Double.class || marshaledObject.getClass() == Long.class || marshaledObject.getClass() == String.class) {
                value = this.marshaler.marshalAnyObject(marshaledObject, cycleDetector.cloneCycleDetector());
            } else if (!cycleDetector.hashDetected(hashCode) || cycleDetector.getHashCount(hashCode) < JSONMarshaler.getCycleLevels()) {
                cycleDetector.addHash(hashCode);
                value = this.marshaler.marshalAnyObject(marshaledObject, cycleDetector.cloneCycleDetector());
            } else {
                value = null;
            }
        }
        return value;
    }
}

