/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij;

import cc.plural.jsonij.ConstantUtility;
import cc.plural.jsonij.Constants;
import cc.plural.jsonij.JSON;
import cc.plural.jsonij.JSONParser;
import cc.plural.jsonij.JSONParserException;
import cc.plural.jsonij.JSONReader;
import cc.plural.jsonij.ReaderJSONReader;
import cc.plural.jsonij.StringJSONReader;
import cc.plural.jsonij.Value;
import cc.plural.jsonij.parser.ParserException;
import cc.plural.jsonij.parser.ReaderParser;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastJSONParser
extends JSONParser {
    private JSONReader target;
    private StringBuilder numericStringBuilder;

    @Override
    public final Value parse(String targetString) throws IOException, ParserException {
        if (targetString == null) {
            throw new NullPointerException();
        }
        if (targetString.trim().equals("")) {
            throw new JSONParserException("invalidEmpty");
        }
        this.target = new StringJSONReader(targetString);
        int r = this.target.peek();
        if (r == -1) {
            throw new JSONParserException("invalidEmpty");
        }
        Value value = null;
        value = r == 123 ? this.parseObject() : (r == 91 ? this.parseArray() : this.parseValue());
        if (this.target.peek() != -1) {
            // empty if block
        }
        return value;
    }

    @Override
    public final Value parse(Reader targetReader) throws IOException, ParserException {
        if (targetReader == null) {
            throw new NullPointerException();
        }
        this.target = new ReaderJSONReader(targetReader);
        int r = this.target.peek();
        if (r == -1) {
            throw new JSONParserException("invalidEmpty");
        }
        Value value = null;
        if (r == 123) {
            value = this.parseObject();
        } else if (r == 91) {
            value = this.parseArray();
        } else {
            throw new JSONParserException("invalidExpecting2", 123, 91, new Object[]{Character.valueOf((char)r)});
        }
        if (this.target.peek() != -1) {
            // empty if block
        }
        return value;
    }

    public final Value parseValue() throws IOException, ParserException {
        Value value = null;
        int p = this.target.peek();
        if (p == 34) {
            value = this.parseString();
        } else if (p == 123) {
            value = this.parseObject();
        } else if (p == 91) {
            value = this.parseArray();
        } else if (ConstantUtility.isNumeric(p)) {
            value = this.parseNumeric();
        } else if (p == "true".charAt(0)) {
            value = this.parseTrue();
        } else if (p == "false".charAt(0)) {
            value = this.parseFalse();
        } else if (p == "null".charAt(0)) {
            value = this.parseNull();
        } else {
            throw new JSONParserException("invalidUnexpected", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf((char)this.target.peek())});
        }
        return value;
    }

    public final JSON.Object<JSON.String, Value> parseObject() throws IOException, ParserException {
        if (this.target.peek() != 123) {
            throw new JSONParserException("invalidObjectExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf('{'), Character.valueOf((char)this.target.peek())});
        }
        this.target.read();
        JSON.Object<JSON.String, Value> value = new JSON.Object<JSON.String, Value>();
        if (this.target.peek() != 125) {
            JSON.String attributeName = this.parseString();
            if (this.target.peek() != 58) {
                throw new JSONParserException("invalidObjectExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf(':'), Character.valueOf((char)this.target.peek())});
            }
            this.target.read();
            Value attributeValue = this.parseValue();
            value.put(attributeName, attributeValue);
            while (this.target.peek() == 44) {
                this.target.read();
                attributeName = this.parseString();
                if (value.containsKey(attributeName)) {
                    throw new JSONParserException("invalidKeyAlreadyUsed", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{attributeName});
                }
                if (this.target.peek() != 58) {
                    throw new JSONParserException("invalidObjectExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf(':'), Character.valueOf((char)this.target.peek())});
                }
                this.target.read();
                attributeValue = this.parseValue();
                value.put(attributeName, attributeValue);
            }
        }
        if (this.target.peek() != 125) {
            throw new JSONParserException("invalidArrayExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf('}'), Character.valueOf((char)this.target.peek())});
        }
        this.target.read();
        return value;
    }

    public final JSON.Array<Value> parseArray() throws IOException, ParserException {
        if (this.target.peek() != 91) {
            throw new JSONParserException("invalidArrayExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf('['), Character.valueOf((char)this.target.peek())});
        }
        this.target.read();
        JSON.Array<Value> value = new JSON.Array<Value>();
        if (this.target.peek() != 93) {
            Value arrayValue = this.parseValue();
            value.add(arrayValue);
            while (this.target.peek() == 44) {
                this.target.read();
                arrayValue = this.parseValue();
                value.add(arrayValue);
            }
        }
        if (this.target.peek() != 93) {
            throw new JSONParserException("invalidArrayExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)this.target.peek())});
        }
        this.target.read();
        return value;
    }

    public final JSON.String parseString() throws IOException, ParserException {
        int p;
        JSON.String value = null;
        if (this.target.peek() != 34) {
            throw new JSONParserException("invalidStringExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf('\"'), Character.valueOf((char)this.target.peek())});
        }
        StringBuilder valueStringBuilder = new StringBuilder();
        ReaderParser targetString = this.target.getStringReader();
        targetString.read();
        while ((p = targetString.peek()) != 34) {
            if (p == 92) {
                targetString.read();
                p = targetString.peek();
                switch (p) {
                    case 34: {
                        valueStringBuilder.append('\"');
                        targetString.read();
                        break;
                    }
                    case 92: {
                        valueStringBuilder.append('\\');
                        targetString.read();
                        break;
                    }
                    case 47: {
                        valueStringBuilder.append('/');
                        targetString.read();
                        break;
                    }
                    case 98: {
                        valueStringBuilder.append('\b');
                        targetString.read();
                        break;
                    }
                    case 102: {
                        valueStringBuilder.append('\f');
                        targetString.read();
                        break;
                    }
                    case 110: {
                        valueStringBuilder.append('\n');
                        targetString.read();
                        break;
                    }
                    case 114: {
                        valueStringBuilder.append('\r');
                        targetString.read();
                        break;
                    }
                    case 116: {
                        valueStringBuilder.append('\t');
                        targetString.read();
                        break;
                    }
                    case 117: {
                        targetString.read();
                        StringBuilder unicodeStringBuilder = new StringBuilder();
                        for (int i = 0; i < 4; ++i) {
                            if (!ConstantUtility.isHexDigit(targetString.peek())) {
                                throw new JSONParserException("invalidStringHex", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek()});
                            }
                            unicodeStringBuilder.append((char)targetString.read());
                        }
                        int unicodeInt = Integer.parseInt(unicodeStringBuilder.toString().toUpperCase(), 16);
                        if (Character.isHighSurrogate((char)unicodeInt)) {
                            String highSurrogateString = unicodeStringBuilder.toString();
                            int highSurrogate = unicodeInt;
                            unicodeStringBuilder = new StringBuilder();
                            if (targetString.peek() != 92) {
                                throw new JSONParserException("invalidStringMissingSurrogate", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{92, targetString.peek()});
                            }
                            targetString.read();
                            if (targetString.peek() != 117) {
                                throw new JSONParserException("invalidStringMissingSurrogate", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{117, targetString.peek()});
                            }
                            targetString.read();
                            for (int i = 0; i < 4; ++i) {
                                if (!ConstantUtility.isHexDigit(targetString.peek())) {
                                    throw new JSONParserException("invalidStringHex", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek()});
                                }
                                unicodeStringBuilder.append((char)targetString.read());
                            }
                            String lowSurrogateString = unicodeStringBuilder.toString();
                            int lowSurrogate = Integer.parseInt(lowSurrogateString.toUpperCase(), 16);
                            if (Character.isSurrogatePair((char)highSurrogate, (char)lowSurrogate)) {
                                char[] c = Character.toChars(Character.toCodePoint((char)highSurrogate, (char)lowSurrogate));
                                valueStringBuilder.append(new String(c));
                                break;
                            }
                            throw new JSONParserException("invalidStringSurrogates", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{highSurrogateString, lowSurrogateString});
                        }
                        if (ConstantUtility.isValidStringChar(unicodeInt)) {
                            valueStringBuilder.append((char)unicodeInt);
                            break;
                        }
                        throw new JSONParserException("invalidStringValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{unicodeInt, unicodeStringBuilder.toString()});
                    }
                    default: {
                        throw new JSONParserException("invalidStringEscape", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek()});
                    }
                }
                continue;
            }
            if (ConstantUtility.isValidStringChar(p)) {
                valueStringBuilder.append((char)targetString.read());
                continue;
            }
            throw new JSONParserException("invalidStringValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{targetString.peek(), Character.valueOf((char)targetString.peek())});
        }
        if (targetString.peek() != 34) {
            throw new JSONParserException("invalidStringExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf('\"'), Character.valueOf((char)targetString.peek())});
        }
        targetString.read();
        targetString.close();
        value = new JSON.String(valueStringBuilder.toString());
        return value;
    }

    public final JSON.Numeric parseNumeric() throws IOException, ParserException {
        JSON.Numeric value = null;
        this.numericStringBuilder = new StringBuilder();
        boolean minusFlag = false;
        boolean decimalFlag = false;
        boolean exponetFlag = false;
        int beforeDecimalCount = 0;
        int afterDecimalCount = 0;
        if (this.target.peek() == 45) {
            minusFlag = true;
            this.target.read();
            this.numericStringBuilder.append('-');
            if (this.target.peek() < Constants.DIGITS[0] || this.target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf((char)this.target.peek())});
            }
        }
        if (this.target.peek() == Constants.DIGITS[0]) {
            this.numericStringBuilder.append((char)this.target.read());
            ++beforeDecimalCount;
        } else if (this.target.peek() >= Constants.DIGITS[1] && this.target.peek() <= Constants.DIGITS[9]) {
            this.numericStringBuilder.append((char)this.target.read());
            ++beforeDecimalCount;
            while (ConstantUtility.isDigit(this.target.peek())) {
                this.numericStringBuilder.append((char)this.target.read());
                ++beforeDecimalCount;
            }
        } else {
            throw new JSONParserException("invalidNumericExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf((char)this.target.peek())});
        }
        if (this.target.peek() == 46) {
            this.target.read();
            decimalFlag = true;
            this.numericStringBuilder.append('.');
            if (this.target.peek() < Constants.DIGITS[0] || this.target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf((char)this.target.peek())});
            }
            while (ConstantUtility.isDigit(this.target.peek())) {
                this.numericStringBuilder.append((char)this.target.read());
                ++afterDecimalCount;
            }
        }
        if (this.target.peek() == Constants.EXPS[0] || this.target.peek() == Constants.EXPS[1]) {
            this.target.read();
            exponetFlag = true;
            this.numericStringBuilder.append(Constants.EXPS[1]);
            if (this.target.peek() == 45) {
                this.target.read();
                this.numericStringBuilder.append('-');
            } else if (this.target.peek() == 43) {
                this.target.read();
                this.numericStringBuilder.append('+');
            } else {
                this.numericStringBuilder.append('+');
            }
            if (this.target.peek() < Constants.DIGITS[0] || this.target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{Character.valueOf((char)this.target.peek())});
            }
            while (ConstantUtility.isDigit(this.target.peek())) {
                this.numericStringBuilder.append((char)this.target.read());
            }
        }
        value = !decimalFlag && !exponetFlag ? (beforeDecimalCount < 16 ? new JSON.Numeric(Long.parseLong(this.numericStringBuilder.toString())) : new JSON.Numeric(new BigInteger(this.numericStringBuilder.toString()))) : (beforeDecimalCount + afterDecimalCount < 16 ? new JSON.Numeric(Double.parseDouble(this.numericStringBuilder.toString())) : new JSON.Numeric(new BigDecimal(this.numericStringBuilder.toString())));
        return value;
    }

    public final JSON.True parseTrue() throws IOException, ParserException {
        for (int i = 0; i < "true".length(); ++i) {
            if (this.target.peek() != "true".charAt(i)) {
                throw new JSONParserException("invalidValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{"true", Character.valueOf((char)this.target.peek())});
            }
            this.target.read();
        }
        return JSON.TRUE;
    }

    public final JSON.False parseFalse() throws IOException, ParserException {
        for (int i = 0; i < "false".length(); ++i) {
            if (this.target.peek() != "false".charAt(i)) {
                throw new JSONParserException("invalidValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{"false", Character.valueOf((char)this.target.peek())});
            }
            this.target.read();
        }
        return JSON.FALSE;
    }

    public final JSON.Null parseNull() throws IOException, ParserException {
        for (int i = 0; i < "null".length(); ++i) {
            if (this.target.peek() != "null".charAt(i)) {
                throw new JSONParserException("invalidValue", this.target.getLineNumber(), this.target.getPositionNumber(), new Object[]{"null", Character.valueOf((char)this.target.peek())});
            }
            this.target.read();
        }
        return JSON.NULL;
    }
}

