/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json.marshal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jsonij.json.JSON;
import jsonij.json.Value;
import jsonij.json.annotation.JSONEncoder;
import jsonij.json.marshal.Inspector;
import jsonij.json.marshal.JSONCodec;
import jsonij.json.marshal.JSONCodecStore;
import jsonij.json.marshal.JavaMarshaler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaObjectMarshaler {
    protected JavaMarshaler marshaler;
    protected final Map<Class<?>, Inspector> inspectedClasses;
    static JSONCodecStore codecStore;

    public JavaObjectMarshaler(JavaMarshaler marshaler) {
        this.marshaler = marshaler;
        this.inspectedClasses = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isObjectType(Class<?> objectClass) {
        Inspector inspector = null;
        Map<Class<?>, Inspector> map = this.inspectedClasses;
        synchronized (map) {
            if (this.inspectedClasses.containsKey(objectClass)) {
                inspector = this.inspectedClasses.get(objectClass);
            } else {
                inspector = new Inspector(objectClass);
                inspector.inspect();
                this.inspectedClasses.put(objectClass, inspector);
            }
        }
        Inspector.InspectorProperty[] properties = inspector.getProperties();
        if (properties != null) {
            for (Inspector.InspectorProperty property : properties) {
                if (!property.isValidAccessor()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value marshalJavaObject(Object o, JavaMarshaler.CycleDetector cycleDetector) {
        Method[] methods;
        Class<?> objectClass = o.getClass();
        for (Method method : methods = objectClass.getDeclaredMethods()) {
            if (method.getAnnotation(JSONEncoder.class) == null) continue;
        }
        if (codecStore != null && codecStore.hasCodec(objectClass)) {
            JSONCodec<?> codec = codecStore.getCodec(objectClass);
            Value value = codec.encode(o);
            return value;
        }
        Inspector inspector = null;
        Map<Class<?>, Inspector> value = this.inspectedClasses;
        synchronized (value) {
            if (this.inspectedClasses.containsKey(objectClass)) {
                inspector = this.inspectedClasses.get(objectClass);
            } else {
                inspector = new Inspector(o);
                inspector.inspect();
                this.inspectedClasses.put(objectClass, inspector);
            }
        }
        JSON.Object<JSON.String, Value> marshaledObject = new JSON.Object<JSON.String, Value>();
        Inspector.InspectorProperty[] properties = inspector.getProperties();
        String name = null;
        Value value2 = null;
        for (Inspector.InspectorProperty property : properties) {
            block22: {
                String accessorName;
                if (property.isIgnore() || !property.isValidAccessor()) continue;
                name = property.getName();
                if (property.getAccessType() == Inspector.InspectorProperty.TYPE.METHOD) {
                    accessorName = property.getAccessName();
                    try {
                        Method method = objectClass.getMethod(accessorName, new Class[0]);
                        value2 = this.marshalObjectMethodValue(method, o, cycleDetector);
                        if (value2 == null) {
                            continue;
                        }
                        break block22;
                    }
                    catch (Exception ex) {
                        value2 = new JSON.String(ex.toString());
                        break block22;
                    }
                }
                if (property.getAccessType() == Inspector.InspectorProperty.TYPE.FIELD) {
                    accessorName = property.getAccessName();
                    try {
                        Field field = objectClass.getField(accessorName);
                        value2 = this.marshalObjectFieldValue(field, o, cycleDetector);
                        if (value2 == null) {
                            continue;
                        }
                        break block22;
                    }
                    catch (Exception ex) {
                        value2 = new JSON.String(ex.toString());
                        break block22;
                    }
                }
                value2 = JSON.NULL;
            }
            marshaledObject.put(new JSON.String(name), value2);
        }
        boolean isList = false;
        Class<?>[] interfaces = null;
        Class<?> parent = o.getClass().getSuperclass();
        if (parent != null) {
            block9: do {
                interfaces = parent.getInterfaces();
                for (int i = 0; i < Array.getLength(interfaces); ++i) {
                    if (interfaces[i] != List.class) continue;
                    isList = true;
                    continue block9;
                }
            } while (!isList && (parent = parent.getSuperclass()) != null);
        }
        if (isList) {
            if (marshaledObject.size() > 0) {
                marshaledObject.put(new JSON.String("_entries"), this.marshaler.marshalJavaList(o, cycleDetector));
            } else {
                return this.marshaler.marshalJavaList(o, cycleDetector);
            }
        }
        return marshaledObject;
    }

    protected Value marshalObjectMethodValue(Method method, Object o, JavaMarshaler.CycleDetector cycleDetector) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Value value = null;
        Object marshaledObject = method.invoke(o, new Object[0]);
        if (marshaledObject == null) {
            value = null;
        } else {
            int hashCode = marshaledObject.hashCode();
            if (!cycleDetector.hashDetected(hashCode)) {
                cycleDetector.addHash(hashCode);
                value = this.marshaler.marshalAnyObject(marshaledObject, cycleDetector.cloneCycleDetector());
            } else {
                value = null;
            }
        }
        return value;
    }

    protected Value marshalObjectFieldValue(Field field, Object o, JavaMarshaler.CycleDetector cycleDetector) throws IllegalArgumentException, IllegalAccessException {
        Value value = null;
        Object marshaledObject = field.get(o);
        if (marshaledObject == null) {
            value = null;
        } else {
            int hashCode = marshaledObject.hashCode();
            if (!cycleDetector.hashDetected(hashCode)) {
                cycleDetector.addHash(hashCode);
                value = this.marshaler.marshalAnyObject(marshaledObject, cycleDetector.cloneCycleDetector());
            } else {
                value = null;
            }
        }
        return value;
    }

    public static boolean hasCodec(Class codecType) {
        if (codecStore == null) {
            return false;
        }
        return codecStore.hasCodec(codecType);
    }

    public static void registerCodec(Class<?> codecClass) {
        if (codecStore == null) {
            codecStore = new JSONCodecStore();
        }
        codecStore.registerCodec(codecClass);
    }

    public static JSONCodec<?> getCodec(Class codecType) {
        if (codecStore == null) {
            return null;
        }
        return codecStore.getCodec(codecType);
    }
}

