/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.IOException;
import java.io.Reader;
import jsonij.json.ConstantUtility;
import jsonij.json.JSONReader;
import jsonij.parser.Position;
import jsonij.parser.ReaderParser;

public class ReaderJSONReader
extends JSONReader {
    protected Reader reader;
    ReaderJSONStringReader stringReader;

    public ReaderJSONReader(Reader reader) {
        this.reader = reader;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public int readNext() throws IOException {
        if (this.reader == null) {
            throw new NullPointerException("Null Reader Exception.");
        }
        int r = -1;
        while (this.reader.ready() && (r = this.reader.read()) != -1) {
            this.getPosition().tickReadCount();
            this.getPosition().movePosition();
            if (ConstantUtility.isNewLine(r)) {
                this.handleNewLine();
                continue;
            }
            if (ConstantUtility.isWhiteSpace(r)) continue;
            break;
        }
        return r;
    }

    public ReaderParser getStringReader() {
        if (this.stringReader == null) {
            this.stringReader = new ReaderJSONStringReader();
        }
        return this.stringReader;
    }

    protected class ReaderJSONStringReader
    implements ReaderParser {
        protected boolean active = true;

        public boolean isActive() {
            return this.active;
        }

        protected void setActive(boolean active) {
            this.active = active;
        }

        public int peek() throws IOException {
            if (ReaderJSONReader.this.stringReader == null || !this.active) {
                // empty if block
            }
            if (!ReaderJSONReader.this.hasPeeked) {
                ReaderJSONReader.this.peekValue = this.readNext();
                ReaderJSONReader.this.hasPeeked = true;
            }
            return ReaderJSONReader.this.peekValue;
        }

        public int read() throws IOException {
            if (ReaderJSONReader.this.stringReader == null || !this.active) {
                // empty if block
            }
            if (ReaderJSONReader.this.hasPeeked) {
                ReaderJSONReader.this.hasPeeked = false;
                return ReaderJSONReader.this.peekValue;
            }
            return this.readNext();
        }

        public void close() {
            ReaderJSONReader.this.stringReader = null;
            this.active = false;
        }

        protected int readNext() throws IOException {
            if (ReaderJSONReader.this.reader == null) {
                throw new NullPointerException("Null Reader Exception.");
            }
            int r = -1;
            while (ReaderJSONReader.this.reader.ready() && (r = ReaderJSONReader.this.reader.read()) != -1) {
                this.getPosition().tickReadCount();
                this.getPosition().movePosition();
                if (!ConstantUtility.isNewLine(r)) break;
                ReaderJSONReader.this.handleNewLine();
            }
            return r;
        }

        public Position getPosition() {
            return ReaderJSONReader.this.getPosition();
        }

        public boolean isHasPeeked() {
            return ReaderJSONReader.this.isHasPeeked();
        }

        public boolean hasPeeked() {
            return ReaderJSONReader.this.hasPeeked();
        }

        public void setHasPeeked(boolean hasPeeked) {
            ReaderJSONReader.this.setHasPeeked(hasPeeked);
        }

        public int getLineNumber() {
            return ReaderJSONReader.this.getLineNumber();
        }

        public int getPositionNumber() {
            return ReaderJSONReader.this.getPositionNumber();
        }
    }
}

