/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import jsonij.json.ConstantUtility;
import jsonij.json.JPath;
import jsonij.json.JPathParserException;
import jsonij.json.JSONParser;
import jsonij.json.Value;
import jsonij.parser.ParserException;
import jsonij.parser.ReaderParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPathParser {
    public JPath<JPath.Component> parse(String jPath) throws IOException, ParserException {
        StringReader jPathStringReader = new StringReader(jPath);
        return this.parse(jPathStringReader);
    }

    public JPath<JPath.Component> parse(Reader jPathReader) throws IOException, ParserException {
        JPathReader target = new JPathReader(jPathReader);
        JPath<JPath.Component> path = new JPath<JPath.Component>();
        while (target.peek() != -1) {
            if (target.peek() == 47) {
                target.read();
                continue;
            }
            if (target.peek() == 91) {
                JPath.Predicate predicate = this.readPredicate(target);
                if (predicate == null) continue;
                path.add(predicate);
                continue;
            }
            JPath.Key key = this.readKey(target);
            if (key == null) continue;
            path.add(key);
        }
        return path;
    }

    public JPath.Key readKey(JPathReader target) throws IOException, ParserException {
        StringBuilder keyBuilder = new StringBuilder();
        while (target.peek() != -1 && target.peek() != 47 && target.peek() != 91) {
            if (target.peek() == 92) {
                target.read();
                keyBuilder.append((char)target.read());
                continue;
            }
            keyBuilder.append((char)target.read());
        }
        return new JPath.Key(keyBuilder.toString());
    }

    public JPath.Predicate readPredicate(JPathReader target) throws IOException, ParserException {
        if (target.peek() == -1) {
            return null;
        }
        if (target.peek() != 91) {
            throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('['), Character.valueOf((char)target.peek())});
        }
        target.read();
        StringBuilder predicateComponentBuilder = null;
        if (ConstantUtility.isDigit(target.peek())) {
            predicateComponentBuilder = new StringBuilder();
            predicateComponentBuilder.append((char)target.read());
            while (ConstantUtility.isDigit(target.peek())) {
                predicateComponentBuilder.append((char)target.read());
            }
            if (target.peek() == 93) {
                target.read();
                return new JPath.SimpleIndex(Integer.parseInt(predicateComponentBuilder.toString()));
            }
            throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
        }
        if (target.peek() == 36) {
            target.read();
            if (target.peek() == 93) {
                target.read();
                return JPath.LastIndex.LAST;
            }
            if (target.peek() == 45) {
                target.read();
                if (ConstantUtility.isDigit(target.peek())) {
                    predicateComponentBuilder = new StringBuilder();
                    predicateComponentBuilder.append((char)target.read());
                    while (ConstantUtility.isDigit(target.peek())) {
                        predicateComponentBuilder.append((char)target.read());
                    }
                    if (target.peek() == 93) {
                        target.read();
                        return new JPath.LastIndex(Integer.parseInt(predicateComponentBuilder.toString()));
                    }
                    throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
                }
                throw new UnsupportedOperationException("Not a digit in LastIndex.");
            }
            throw new JPathParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
        }
        if (target.peek() == "last()".charAt(0)) {
            for (int i = 0; i < "last()".length(); ++i) {
                if (target.peek() != "last()".charAt(i)) {
                    throw new JPathParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{"last()", Character.valueOf((char)target.peek())});
                }
                target.read();
            }
            if (target.peek() == 93) {
                target.read();
                return JPath.LastIndex.LAST;
            }
            if (target.peek() == 45) {
                target.read();
                if (ConstantUtility.isDigit(target.peek())) {
                    predicateComponentBuilder = new StringBuilder();
                    predicateComponentBuilder.append((char)target.read());
                    while (ConstantUtility.isDigit(target.peek())) {
                        predicateComponentBuilder.append((char)target.read());
                    }
                    if (target.peek() == 93) {
                        target.read();
                        return new JPath.LastIndex(Integer.parseInt(predicateComponentBuilder.toString()));
                    }
                    throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
                }
                throw new UnsupportedOperationException("Not a digit in LastIndex.");
            }
            throw new JPathParserException("invalidPathExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
        }
        if (target.peek() == 63) {
            JPath.ExpressionPredicate expressionPredicate = new JPath.ExpressionPredicate();
            target.read();
            if (target.peek() == 40) {
                target.read();
                StringBuilder expressionStringBuilder = new StringBuilder();
                while (target.peek() != 41) {
                    if (target.peek() == -1) {
                        throw new JPathParserException("invalidPathFoundEndExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(')'), Character.valueOf((char)target.peek())});
                    }
                    target.skipWhitepace(expressionStringBuilder);
                    JPath.ExpressionPredicateCombineOperator op = null;
                    if (target.peek() == 38) {
                        while (target.peek() == 38) {
                            expressionStringBuilder.append((char)target.read());
                        }
                        op = JPath.ExpressionPredicateCombineOperator.AND;
                    } else if (target.peek() == 124) {
                        while (target.peek() == 124) {
                            expressionStringBuilder.append((char)target.read());
                        }
                        op = JPath.ExpressionPredicateCombineOperator.OR;
                    }
                    target.skipWhitepace(expressionStringBuilder);
                    if (target.peek() == 64) {
                        char c;
                        expressionStringBuilder.append((char)target.read());
                        if (target.peek() != 46) continue;
                        expressionStringBuilder.append((char)target.read());
                        target.skipWhitepace(expressionStringBuilder);
                        String attribute = null;
                        String value = null;
                        predicateComponentBuilder = new StringBuilder();
                        while (target.peek() != 41 && target.peek() != 60 && target.peek() != 62 && target.peek() != 61) {
                            c = (char)target.read();
                            expressionStringBuilder.append(c);
                            predicateComponentBuilder.append(c);
                        }
                        attribute = predicateComponentBuilder.toString().trim();
                        JPath.ExpressionPredicateOperator expressionPredicateOperator = null;
                        if (target.peek() == 41) {
                            expressionStringBuilder.append((char)target.read());
                            expressionPredicateOperator = JPath.ExpressionPredicateOperator.NOT_NULL;
                        } else if (target.peek() == 61) {
                            expressionStringBuilder.append((char)target.read());
                            expressionPredicateOperator = JPath.ExpressionPredicateOperator.EQUAL;
                        } else if (target.peek() == 60) {
                            expressionStringBuilder.append((char)target.read());
                            if (target.peek() == 61) {
                                expressionStringBuilder.append((char)target.read());
                                expressionPredicateOperator = JPath.ExpressionPredicateOperator.LESS_EQUAL;
                            } else {
                                expressionPredicateOperator = JPath.ExpressionPredicateOperator.LESS;
                            }
                        } else if (target.peek() == 62) {
                            expressionStringBuilder.append((char)target.read());
                            if (target.peek() == 61) {
                                expressionStringBuilder.append((char)target.read());
                                expressionPredicateOperator = JPath.ExpressionPredicateOperator.GREATER_EQUAL;
                            } else {
                                expressionPredicateOperator = JPath.ExpressionPredicateOperator.GREATER;
                            }
                        }
                        target.skipWhitepace(expressionStringBuilder);
                        predicateComponentBuilder = new StringBuilder();
                        while (target.peek() != 41 && target.peek() != 38 && target.peek() != 124) {
                            if (target.peek() == -1) {
                                throw new JPathParserException("invalidPathFoundEndExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(')'), Character.valueOf((char)target.peek())});
                            }
                            c = (char)target.read();
                            expressionStringBuilder.append(c);
                            predicateComponentBuilder.append(c);
                        }
                        value = predicateComponentBuilder.toString().trim();
                        JSONParser jsonParser = new JSONParser();
                        Value jsonValue = jsonParser.parseValue(value);
                        target.skipWhitepace(expressionStringBuilder);
                        JPath.ExpressionPredicateCondition predicateCondition = new JPath.ExpressionPredicateCondition(attribute, expressionPredicateOperator, jsonValue);
                        if (op != null) {
                            predicateCondition.setCombine(op);
                            op = null;
                        }
                        expressionPredicate.conditions().add(predicateCondition);
                        continue;
                    }
                    throw new JPathParserException("expression1", target.getPositionNumber());
                }
                target.read();
                expressionPredicate.setExpression(expressionStringBuilder.toString());
                if (target.peek() == 93) {
                    expressionStringBuilder.append((char)target.read());
                }
                return expressionPredicate;
            }
            throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('('), Character.valueOf((char)target.peek())});
        }
        throw new UnsupportedOperationException("Invalid Predicate.");
    }

    public static class JPathReader
    extends ReaderParser {
        public JPathReader() {
            this(null);
        }

        public JPathReader(Reader reader) {
            super(reader);
        }

        protected int readNext() throws IOException, ParserException {
            return this.getReader().read();
        }

        public void skipWhitepace() throws IOException, ParserException {
            while (ConstantUtility.isWhiteSpace(this.peek())) {
                this.read();
            }
        }

        public void skipWhitepace(StringBuilder appender) throws IOException, ParserException {
            while (ConstantUtility.isWhiteSpace(this.peek())) {
                appender.append((char)this.read());
            }
        }
    }
}

