/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.jpath;

import cc.plural.jsonij.ConstantUtility;
import cc.plural.jsonij.JPath;
import cc.plural.jsonij.JSONParser;
import cc.plural.jsonij.Value;
import cc.plural.jsonij.jpath.AllPredicate;
import cc.plural.jsonij.jpath.Component;
import cc.plural.jsonij.jpath.ExpressionPredicate;
import cc.plural.jsonij.jpath.JPathParserException;
import cc.plural.jsonij.jpath.KeyComponent;
import cc.plural.jsonij.jpath.LastIndexPredicate;
import cc.plural.jsonij.jpath.PredicateComponent;
import cc.plural.jsonij.jpath.SearchComponent;
import cc.plural.jsonij.jpath.SimpleIndexPredicate;
import cc.plural.jsonij.jpath.StartEndStepPredicate;
import cc.plural.jsonij.jpath.UnionPredicate;
import cc.plural.jsonij.jpath.functions.FunctionArgument;
import cc.plural.jsonij.parser.BaseReaderParser;
import cc.plural.jsonij.parser.ParserException;
import cc.plural.jsonij.parser.ReaderParser;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPathParser {
    public JPath<Component> parse(String jPath) throws IOException, ParserException {
        JPathReader target = new JPathReader(jPath);
        return this.parse(target);
    }

    public JPath<Component> parse(JPathReader target) throws IOException, ParserException {
        JPath<Component> path = new JPath<Component>();
        while (target.peek() != -1) {
            if (target.peek() == 47) {
                target.read();
                if (target.peek() != 47) continue;
                target.read();
                path.add(new SearchComponent());
                continue;
            }
            if (target.peek() == 91) {
                PredicateComponent predicate = this.readPredicate(target);
                if (predicate == null) continue;
                path.add(predicate);
                continue;
            }
            KeyComponent key = this.readKey(target);
            if (key == null) continue;
            path.add(key);
        }
        return path;
    }

    public KeyComponent readKey(JPathReader target) throws IOException, ParserException {
        StringBuilder keyBuilder = new StringBuilder();
        while (target.peek() != -1 && target.peek() != 47 && target.peek() != 91) {
            if (target.peek() == 92) {
                target.read();
                keyBuilder.append((char)target.read());
                continue;
            }
            keyBuilder.append((char)target.read());
        }
        return new KeyComponent(keyBuilder.toString());
    }

    public PredicateComponent readPredicate(JPathReader target) throws IOException, ParserException {
        if (target.peek() == -1) {
            return null;
        }
        if (target.peek() != 91) {
            throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('['), Character.valueOf((char)target.peek())});
        }
        target.read();
        StringBuilder predicateComponentBuilder = null;
        if (target.peek() == 42) {
            target.read();
            if (target.peek() == 93) {
                target.read();
            }
            return new AllPredicate();
        }
        if (ConstantUtility.isNumeric(target.peek())) {
            predicateComponentBuilder = new StringBuilder();
            predicateComponentBuilder.append((char)target.read());
            while (ConstantUtility.isNumeric(target.peek())) {
                predicateComponentBuilder.append((char)target.read());
            }
            if (target.peek() == 93) {
                target.read();
                return new SimpleIndexPredicate(Integer.parseInt(predicateComponentBuilder.toString()));
            }
            if (target.peek() == 44) {
                UnionPredicate unionPredicate = new UnionPredicate();
                int index = -1;
                while (ConstantUtility.isNumeric(target.peek()) || target.peek() == 44) {
                    if (target.peek() == 44) {
                        index = Integer.parseInt(predicateComponentBuilder.toString());
                        unionPredicate.addIndex(index);
                        target.read();
                        predicateComponentBuilder = new StringBuilder();
                        continue;
                    }
                    if (!ConstantUtility.isNumeric(target.peek())) continue;
                    predicateComponentBuilder.append((char)target.read());
                }
                if (target.peek() == 93) {
                    index = Integer.parseInt(predicateComponentBuilder.toString());
                    unionPredicate.addIndex(index);
                    target.read();
                    return unionPredicate;
                }
                throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
            }
            if (target.peek() == 58) {
                int start = Integer.parseInt(predicateComponentBuilder.toString());
                int end = -1;
                boolean step = true;
                StartEndStepPredicate startEndStepPredicate = new StartEndStepPredicate();
                if (target.peek() == 93) {
                    int num = Integer.parseInt(predicateComponentBuilder.toString());
                    target.read();
                    return startEndStepPredicate;
                }
                throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
            }
            throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
        }
        if (target.peek() == 36) {
            target.read();
            if (target.peek() == 93) {
                target.read();
                return LastIndexPredicate.LAST;
            }
            if (target.peek() == 45) {
                target.read();
                if (ConstantUtility.isDigit(target.peek())) {
                    predicateComponentBuilder = new StringBuilder();
                    predicateComponentBuilder.append((char)target.read());
                    while (ConstantUtility.isDigit(target.peek())) {
                        predicateComponentBuilder.append((char)target.read());
                    }
                    if (target.peek() == 93) {
                        target.read();
                        return new LastIndexPredicate(Integer.parseInt(predicateComponentBuilder.toString()));
                    }
                    throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
                }
                throw new UnsupportedOperationException("Not a digit in LastIndex.");
            }
            throw new JPathParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
        }
        if (target.peek() == "last()".charAt(0)) {
            for (int i = 0; i < "last()".length(); ++i) {
                if (target.peek() != "last()".charAt(i)) {
                    throw new JPathParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{"last()", Character.valueOf((char)target.peek())});
                }
                target.read();
            }
            if (target.peek() == 93) {
                target.read();
                return LastIndexPredicate.LAST;
            }
            if (target.peek() == 45) {
                target.read();
                if (ConstantUtility.isDigit(target.peek())) {
                    predicateComponentBuilder = new StringBuilder();
                    predicateComponentBuilder.append((char)target.read());
                    while (ConstantUtility.isDigit(target.peek())) {
                        predicateComponentBuilder.append((char)target.read());
                    }
                    if (target.peek() == 93) {
                        target.read();
                        return new LastIndexPredicate(Integer.parseInt(predicateComponentBuilder.toString()));
                    }
                    throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
                }
                throw new UnsupportedOperationException("Not a digit in LastIndex.");
            }
            throw new JPathParserException("invalidPathExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
        }
        if (target.peek() == 58) {
            boolean start = false;
            boolean end = false;
            boolean step = true;
        } else if (target.peek() == 63) {
            ExpressionPredicate expressionPredicate = new ExpressionPredicate();
            target.read();
            if (target.peek() == 40) {
                target.read();
                StringBuilder expressionStringBuilder = new StringBuilder();
                while (target.peek() != 41) {
                    char c;
                    if (target.peek() == -1) {
                        throw new JPathParserException("invalidPathFoundEndExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(')'), Character.valueOf((char)target.peek())});
                    }
                    target.skipWhitepace(expressionStringBuilder);
                    ExpressionPredicate.ExpressionPredicateCombineOperator op = null;
                    if (target.peek() == 38) {
                        while (target.peek() == 38) {
                            expressionStringBuilder.append((char)target.read());
                        }
                        op = ExpressionPredicate.ExpressionPredicateCombineOperator.AND;
                    } else if (target.peek() == 124) {
                        while (target.peek() == 124) {
                            expressionStringBuilder.append((char)target.read());
                        }
                        op = ExpressionPredicate.ExpressionPredicateCombineOperator.OR;
                    }
                    target.skipWhitepace(expressionStringBuilder);
                    if (target.peek() == 64) {
                        expressionStringBuilder.append((char)target.read());
                        if (target.peek() != 46) continue;
                        expressionStringBuilder.append((char)target.read());
                        target.skipWhitepace(expressionStringBuilder);
                        String attribute = null;
                        String value = null;
                        predicateComponentBuilder = new StringBuilder();
                        while (target.peek() != 41 && target.peek() != 60 && target.peek() != 62 && target.peek() != 61) {
                            c = (char)target.read();
                            expressionStringBuilder.append(c);
                            predicateComponentBuilder.append(c);
                        }
                        attribute = predicateComponentBuilder.toString().trim();
                        ExpressionPredicate.ExpressionPredicateOperator expressionPredicateOperator = null;
                        if (target.peek() == 41) {
                            expressionStringBuilder.append((char)target.read());
                            expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.NOT_NULL;
                        } else if (target.peek() == 61) {
                            expressionStringBuilder.append((char)target.read());
                            expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.EQUAL;
                        } else if (target.peek() == 60) {
                            expressionStringBuilder.append((char)target.read());
                            if (target.peek() == 61) {
                                expressionStringBuilder.append((char)target.read());
                                expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.LESS_EQUAL;
                            } else {
                                expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.LESS;
                            }
                        } else if (target.peek() == 62) {
                            expressionStringBuilder.append((char)target.read());
                            if (target.peek() == 61) {
                                expressionStringBuilder.append((char)target.read());
                                expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.GREATER_EQUAL;
                            } else {
                                expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.GREATER;
                            }
                        }
                        target.skipWhitepace(expressionStringBuilder);
                        predicateComponentBuilder = new StringBuilder();
                        while (target.peek() != 41 && target.peek() != 38 && target.peek() != 124) {
                            if (target.peek() == -1) {
                                throw new JPathParserException("invalidPathFoundEndExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(')'), Character.valueOf((char)target.peek())});
                            }
                            c = (char)target.read();
                            expressionStringBuilder.append(c);
                            predicateComponentBuilder.append(c);
                        }
                        value = predicateComponentBuilder.toString().trim();
                        JSONParser jsonParser = new JSONParser();
                        Value jsonValue = jsonParser.parseValue(value);
                        target.skipWhitepace(expressionStringBuilder);
                        ExpressionPredicate.OperatorExpressionPredicateCondition predicateCondition = new ExpressionPredicate.OperatorExpressionPredicateCondition(attribute, expressionPredicateOperator, jsonValue);
                        if (op != null) {
                            predicateCondition.setCombine(op);
                            op = null;
                        }
                        expressionPredicate.conditions().add(predicateCondition);
                        continue;
                    }
                    if (this.jPathFunctionParseCheck(target.peek())) {
                        StringBuilder functionNameBuilder = new StringBuilder();
                        while (target.peek() != -1 && target.peek() != 40) {
                            c = (char)target.read();
                            expressionStringBuilder.append(c);
                            functionNameBuilder.append(c);
                        }
                        c = (char)target.read();
                        expressionStringBuilder.append(c);
                        target.skipWhitepace(expressionStringBuilder);
                        StringBuilder argumentsBuilder = new StringBuilder();
                        while (target.peek() != -1 && target.peek() != 41) {
                            c = (char)target.read();
                            expressionStringBuilder.append(c);
                            argumentsBuilder.append(c);
                        }
                        c = (char)target.read();
                        expressionStringBuilder.append(c);
                        FunctionArgument[] argumentArray = FunctionArgument.parseStringToArguments(argumentsBuilder.toString().trim());
                        ExpressionPredicate.FunctionExpressionPredicateCondition predicateCondition = new ExpressionPredicate.FunctionExpressionPredicateCondition(functionNameBuilder.toString(), argumentArray);
                        expressionPredicate.conditions().add(predicateCondition);
                        continue;
                    }
                    throw new JPathParserException("expression1", 0, target.getPositionNumber(), new Object[]{expressionStringBuilder.toString()});
                }
                target.read();
                expressionPredicate.setExpression(expressionStringBuilder.toString());
                if (target.peek() == 93) {
                    expressionStringBuilder.append((char)target.read());
                }
                return expressionPredicate;
            }
            throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('('), Character.valueOf((char)target.peek())});
        }
        throw new UnsupportedOperationException("Invalid Predicate.");
    }

    public boolean jPathFunctionParseCheck(int i) {
        return i == 114;
    }

    public static class JPathReader
    extends BaseReaderParser
    implements ReaderParser {
        String jPathString;
        int index;

        public JPathReader(String jpathString) {
            this.jPathString = jpathString;
            this.index = 0;
        }

        public String getJPath() {
            return this.jPathString;
        }

        public int readNext() throws IOException, ParserException {
            if (this.index < this.jPathString.length()) {
                return this.jPathString.charAt(this.index++);
            }
            return -1;
        }

        public void skipWhitepace() throws IOException, ParserException {
            while (ConstantUtility.isWhiteSpace(this.peek())) {
                this.read();
            }
        }

        public void skipWhitepace(StringBuilder appender) throws IOException, ParserException {
            while (ConstantUtility.isWhiteSpace(this.peek())) {
                appender.append((char)this.read());
            }
        }
    }
}

