/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.config.JFinalConfig;
import com.jfinal.core.Config;
import com.jfinal.core.Controller;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.support.WebApplicationContextUtils;

class ApplicationContextKit {
    static ApplicationContext applicationContext;

    ApplicationContextKit() {
    }

    static void initApplicationContext(FilterConfig filterConfig) {
        applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext can not be null");
    }

    static <T> T getBean(String beanName) {
        Assert.notNull((Object)beanName, (String)"beanName can not be null");
        return (T)applicationContext.getBean(beanName);
    }

    static <T> T getBean(Class<T> requiredType) {
        Assert.notNull(requiredType, (String)"requiredType can not be null");
        return ApplicationContextKit.getBean(requiredType.getName());
    }

    static void registerController() {
        Set controllerClasses = Config.getRoutes().getEntrySet();
        for (Map.Entry e : controllerClasses) {
            ApplicationContextKit.registerController((Class)e.getValue());
        }
    }

    static void registerController(Class<? extends Controller> controllerClass) {
        Assert.notNull(controllerClass, (String)"controllerClass can not be null");
        ApplicationContextKit.registerBean(applicationContext, controllerClass.getName(), "prototype");
    }

    static JFinalConfig registerJFinalConfig(String configClass) {
        Assert.notNull((Object)configClass, (String)"configClass can not be null");
        ApplicationContextKit.registerBean(applicationContext, configClass, "singleton");
        return (JFinalConfig)applicationContext.getBean(configClass);
    }

    static void registerBean(ApplicationContext applicationContext, String beanName, String scope) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext can not be null");
        Assert.hasText((String)scope, (String)"scope can not be blank");
        Assert.hasText((String)beanName, (String)"beanName can not be blank");
        if (applicationContext.containsBean(beanName)) {
            return;
        }
        BeanDefinition beanDefinition = ApplicationContextKit.genericBeanDefinition(beanName, scope);
        ApplicationContextKit.registerBeanDefinition(applicationContext, beanName, beanDefinition);
    }

    static BeanDefinition genericBeanDefinition(String beanClassName, String scope) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition().getRawBeanDefinition();
        beanDefinition.setScope(scope);
        beanDefinition.setBeanClassName(beanClassName);
        return beanDefinition;
    }

    static void registerBeanDefinition(ApplicationContext applicationContext, String beanName, BeanDefinition beanDefinition) {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
        BeanDefinitionRegistry beanDefinitonRegistry = (BeanDefinitionRegistry)configurableApplicationContext.getBeanFactory();
        beanDefinitonRegistry.registerBeanDefinition(beanName, beanDefinition);
    }
}

