/*
   Copyright 2010 Aaron J. Radke

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package cc.drx

package object p5 {
  import scala.language.implicitConversions

  //constants
  type PGraphics = processing.core.PGraphics
  // val P2D    = processing.core.PConstants.P2D
  // val JAVA2D = processing.core.PConstants.JAVA2D
  // val P3D    = processing.core.PConstants.JAVA2D

  //type Canvas = PGraphics  //old but should this come back? or something like it like DrawContext or something? to support source code compatible alternatives and implicits to them
  //the following focuses around assuming doubles for all floating point ops (this is not a great general assumption but 64bit focus may be ok and limited to the p5 project)
  @inline implicit def float2Double(f:Float) = f.toDouble
  @inline implicit def double2Float(d:Double) = d.toFloat
  @inline implicit def color2Int(color:Color) = color.argb  //required since the processing colors are simply ints, but color should be a ValueClass Int anyways
}
