/*
   Copyright 2010 Aaron J. Radke

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package cc.drx.p5.gui

import cc.drx.p5._
import processing.core._
import processing.core.PConstants._
import processing.core.PApplet._

import cc.drx._

//??this seems to override the cc.drx.Text object
object Text{
   def apply(content:String=""):Text = {val t = new Text; t add content; t}
   def apply(content:String,pos:Vec):Text = {val t = new Text; t add content; t.pos = pos; t}
}
//TODO move this into the Keyboard object that deals with this sort of state in a cross platform manner
class Text(){
   import P5._

   var pos:Vec = Vec(0,0)
   private var cursor = 0
   private var text = ""

   def clear:Unit = {text="" ; cursor=0}
   def home:Unit  = cursor = 0
   def end:Unit   = cursor = text.size
   def left:Unit  = cursor = (cursor - 1).sat(0,text.size)
   def right:Unit = cursor = (cursor + 1).sat(0,text.size)

   def content:String = text
   def head:String = text take cursor
   def tail:String = text drop cursor

   def add(t:String) = {
      text = head + t + tail
      cursor += t.size
   }
   def backspace = {text = head.dropRight(1) + tail; left}
   def delete    = {text = head + tail.drop(1)}

   override def toString = s"Text($head|$tail)"

//TODO move this into the Keyboard object that deals with this sort of state in a cross platform manner
   def update(key:Int,keyCode:Int):Boolean = {
     //println(s"key:$key  keyCode:$keyCode")
     val startSize = content.size
     key match {
        case BACKSPACE => backspace
        case DELETE => delete
        case 1 => home //CTRL-a    || keyCode = 64 + 1
        case 5 => end   //CTRL-e   || keyCode = 64 + 5
        case 21 => clear //CTRL-u  || keyCode = 64 + 21
        case 2 => left  //CTRL-b  || keyCode = 64 + 21
        case 6 => right //CTRL-f  || keyCode = 64 + 21
        //CTRL-w  word rub out
        case 23 => text = head.reverse.dropWhile(_ == ' ').dropWhile(_ != ' ').reverse + tail
        /*
        case ??? => ???   //ALT-b  back a word
        case ??? => ???   //ALT-f  forward a word
        */
        case CODED => keyCode match {
           case LEFT => left
           case RIGHT => right
           case _ => 
        }
        case _ => add(key.toChar.toString)
     }
     startSize != content.size
  }
  //@deprecated("use the more general functionless","v0.1.11")
  def draw(fontsize:Int=10,drawCursor:Boolean=false)(implicit g:PGraphics) = {
     g.textAlign(LEFT,BOTTOM)
     g.text(text,pos.x, pos.y)
     if(drawCursor && Date.ms % 1000 < 500){
        val tx = pos.x + g.textWidth(head)
        val margin = 0.1*fontsize
        g.line(tx, pos.y-fontsize-margin, tx, pos.y+margin)
     }
  }
}

