/*
 * Decompiled with CFR 0.152.
 */
package cc.cloudist.acplibrary.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import java.lang.ref.WeakReference;

public final class PieView
extends View {
    private RectF mBackgroundRect;
    private RectF mPieRect;
    private Paint mBackgroundPaint;
    private Paint mRingPaint;
    private Paint mPiePaint;
    private int mSize;
    private float mBackgroundCornerRadius;
    private float mRingBorderPadding;
    private float mAngle;
    private Handler mHandler = new PieUpdateHandler(this);

    public PieView(Context context, int size, int bgColor, float bgAlpha, float bgCornerRadius, float ringBorderPadding, float pieRingDistance, int ringThickness, int ringColor, float ringAlpha, int pieColor, float pieAlpha) {
        super(context);
        this.mSize = size;
        this.mBackgroundCornerRadius = bgCornerRadius;
        this.mRingBorderPadding = ringBorderPadding;
        this.mBackgroundRect = new RectF(0.0f, 0.0f, (float)size, (float)size);
        float piePaddingValue = (ringBorderPadding + pieRingDistance) * (float)size;
        this.mPieRect = new RectF(0.0f + piePaddingValue / 2.0f, 0.0f + piePaddingValue / 2.0f, (float)size - piePaddingValue / 2.0f, (float)size - piePaddingValue / 2.0f);
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setColor(bgColor);
        this.mBackgroundPaint.setAlpha((int)(bgAlpha * 255.0f));
        this.mRingPaint = new Paint();
        this.mRingPaint.setAntiAlias(true);
        this.mRingPaint.setStrokeWidth((float)ringThickness);
        this.mRingPaint.setColor(ringColor);
        this.mRingPaint.setAlpha((int)(ringAlpha * 255.0f));
        this.mRingPaint.setStyle(Paint.Style.STROKE);
        this.mPiePaint = new Paint();
        this.mPiePaint.setAntiAlias(true);
        this.mPiePaint.setColor(pieColor);
        this.mPiePaint.setAlpha((int)(pieAlpha * 255.0f));
    }

    public void updateAngle(float angle) {
        this.mAngle = angle;
        this.mHandler.sendEmptyMessage(0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mSize, this.mSize);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawRoundRect(this.mBackgroundRect, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, this.mBackgroundPaint);
        canvas.drawCircle((float)(this.mSize / 2), (float)(this.mSize / 2), (float)this.mSize * (1.0f - this.mRingBorderPadding) / 2.0f, this.mRingPaint);
        Log.d((String)"23232", (String)("--" + this.mAngle));
        canvas.drawArc(this.mPieRect, -90.0f, this.mAngle, true, this.mPiePaint);
    }

    private static class PieUpdateHandler
    extends Handler {
        WeakReference<PieView> reference;

        public PieUpdateHandler(PieView pieView) {
            this.reference = new WeakReference<PieView>(pieView);
        }

        public void handleMessage(Message message) {
            PieView pieView = (PieView)((Object)this.reference.get());
            if (pieView != null) {
                pieView.invalidate();
            }
        }
    }
}

