/*
 * Decompiled with CFR 0.152.
 */
package cc.cloudist.acplibrary;

import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import cc.cloudist.acplibrary.ACProgressBaseDialog;
import cc.cloudist.acplibrary.views.PieView;
import java.util.Timer;
import java.util.TimerTask;

public class ACProgressPie
extends ACProgressBaseDialog {
    private Builder mBuilder;
    private PieView mPieView;
    private Timer mTimer;
    private int mSpinCount = 0;

    private ACProgressPie(Builder builder) {
        super(builder.mContext);
        this.mBuilder = builder;
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (ACProgressPie.this.mTimer != null) {
                    ACProgressPie.this.mTimer.cancel();
                    ACProgressPie.this.mTimer = null;
                }
                ACProgressPie.this.mSpinCount = 0;
                ACProgressPie.this.mPieView = null;
            }
        });
    }

    public void show() {
        if (this.mPieView == null) {
            int size = (int)((float)this.getMinimumSideOfScreen(this.mBuilder.mContext) * this.mBuilder.mSizeRatio);
            this.mPieView = new PieView(this.mBuilder.mContext, size, this.mBuilder.mBackgroundColor, this.mBuilder.mBackgroundAlpha, this.mBuilder.mBackgroundCornerRadius, this.mBuilder.mRingBorderPadding, this.mBuilder.mPieRingDistance, this.mBuilder.mRingThickness, this.mBuilder.mRingColor, this.mBuilder.mRingAlpha, this.mBuilder.mPieColor, this.mBuilder.mPieAlpha);
        }
        super.setContentView((View)this.mPieView);
        super.show();
        if (this.mBuilder.mUpdateType == 200) {
            long delay = (long)(1000.0f / this.mBuilder.mSpeed);
            this.mTimer = new Timer();
            this.mTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    int result = ACProgressPie.this.mSpinCount % (ACProgressPie.this.mBuilder.mPieces + 1);
                    ACProgressPie.this.mPieView.updateAngle(360.0f / (float)ACProgressPie.this.mBuilder.mPieces * (float)result);
                    if (result == 0) {
                        ACProgressPie.this.mSpinCount = 1;
                    } else {
                        ACProgressPie.this.mSpinCount++;
                    }
                }
            }, delay, delay);
        }
    }

    public void setPiePercentage(float percentage) {
        if (this.mBuilder.mUpdateType == 201 && this.mPieView != null) {
            this.mPieView.updateAngle(360.0f * percentage);
        }
    }

    public static class Builder {
        private Context mContext;
        private float mSizeRatio = 0.25f;
        private int mBackgroundColor = -16777216;
        private float mBackgroundCornerRadius = 20.0f;
        private float mBackgroundAlpha = 0.5f;
        private int mRingColor = -1;
        private float mRingAlpha = 0.9f;
        private float mRingBorderPadding = 0.2f;
        private int mRingThickness = 3;
        private int mPieColor = -1;
        private float mPieAlpha = 0.9f;
        private float mPieRingDistance = 0.08f;
        private float mSpeed = 6.67f;
        private int mPieces = 100;
        private int mUpdateType = 200;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder sizeRatio(float ratio) {
            this.mSizeRatio = ratio;
            return this;
        }

        public Builder bgColor(int color) {
            this.mBackgroundColor = color;
            return this;
        }

        public Builder bgAlpha(float alpha) {
            this.mBackgroundAlpha = alpha;
            return this;
        }

        public Builder bgCornerRadius(float cornerRadius) {
            this.mBackgroundCornerRadius = cornerRadius;
            return this;
        }

        public Builder ringColor(int color) {
            this.mRingColor = color;
            return this;
        }

        public Builder ringAlpha(float alpha) {
            this.mRingAlpha = alpha;
            return this;
        }

        public Builder ringBorderPadding(float padding) {
            this.mRingBorderPadding = padding;
            return this;
        }

        public Builder ringThickness(int thickness) {
            this.mRingThickness = thickness;
            return this;
        }

        public Builder pieColor(int color) {
            this.mPieColor = color;
            return this;
        }

        public Builder pieAlpha(float alpha) {
            this.mPieAlpha = alpha;
            return this;
        }

        public Builder pieRingDistance(float distance) {
            this.mPieRingDistance = distance;
            return this;
        }

        public Builder speed(float speed) {
            this.mSpeed = speed;
            return this;
        }

        public Builder pieces(int pieces) {
            this.mPieces = pieces;
            return this;
        }

        public Builder updateType(int updateType) {
            this.mUpdateType = updateType;
            return this;
        }

        public ACProgressPie build() {
            return new ACProgressPie(this);
        }
    }
}

