/*
 * Decompiled with CFR 0.152.
 */
package cc.cloudist.acplibrary;

import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import cc.cloudist.acplibrary.ACProgressBaseDialog;
import cc.cloudist.acplibrary.views.FlowerView;
import java.util.Timer;
import java.util.TimerTask;

public class ACProgressFlower
extends ACProgressBaseDialog {
    private Builder mBuilder;
    private FlowerView mFlowerView;
    private int mSpinCount = 0;
    private Timer mTimer;

    private ACProgressFlower(Builder builder) {
        super(builder.mContext);
        this.mBuilder = builder;
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (ACProgressFlower.this.mTimer != null) {
                    ACProgressFlower.this.mTimer.cancel();
                    ACProgressFlower.this.mTimer = null;
                }
                ACProgressFlower.this.mSpinCount = 0;
                ACProgressFlower.this.mFlowerView = null;
            }
        });
    }

    public void show() {
        if (this.mFlowerView == null) {
            int size = (int)((float)this.getMinimumSideOfScreen(this.mBuilder.mContext) * this.mBuilder.mSizeRatio);
            this.mFlowerView = new FlowerView(this.mBuilder.mContext, size, this.mBuilder.mBackgroundColor, this.mBuilder.mBackgroundAlpha, this.mBuilder.mBackgroundCornerRadius, this.mBuilder.mPetalThickness, this.mBuilder.mPetalCount, this.mBuilder.mPetalAlpha, this.mBuilder.mBorderPadding, this.mBuilder.mCenterPadding, this.mBuilder.mThemeColor, this.mBuilder.mFadeColor, this.mBuilder.mText, this.mBuilder.mTextSize, this.mBuilder.mTextColor, this.mBuilder.mTextAlpha, this.mBuilder.mTextMarginTop, this.mBuilder.mTextExpandWidth);
        }
        super.setContentView((View)this.mFlowerView);
        super.show();
        long delay = (long)(1000.0f / this.mBuilder.mSpeed);
        this.mTimer = new Timer();
        this.mTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                int result = ACProgressFlower.this.mSpinCount % ACProgressFlower.this.mBuilder.mPetalCount;
                if (ACProgressFlower.this.mBuilder.mDirection == 100) {
                    ACProgressFlower.this.mFlowerView.updateFocusIndex(result);
                } else {
                    ACProgressFlower.this.mFlowerView.updateFocusIndex(ACProgressFlower.this.mBuilder.mPetalCount - 1 - result);
                }
                if (result == 0) {
                    ACProgressFlower.this.mSpinCount = 1;
                } else {
                    ACProgressFlower.this.mSpinCount++;
                }
            }
        }, delay, delay);
    }

    public static class Builder {
        private Context mContext;
        private float mSizeRatio = 0.25f;
        private float mBorderPadding = 0.55f;
        private float mCenterPadding = 0.27f;
        private int mBackgroundColor = -16777216;
        private int mThemeColor = -1;
        private int mFadeColor = -12303292;
        private int mPetalCount = 12;
        private int mPetalThickness = 9;
        private float mPetalAlpha = 0.5f;
        private float mBackgroundCornerRadius = 20.0f;
        private float mBackgroundAlpha = 0.5f;
        private int mDirection = 100;
        private float mSpeed = 9.0f;
        private String mText = null;
        private int mTextColor = -1;
        private float mTextAlpha = 0.5f;
        private float mTextSize = 40.0f;
        private int mTextMarginTop = 40;
        private boolean mTextExpandWidth = true;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder sizeRatio(float ratio) {
            this.mSizeRatio = ratio;
            return this;
        }

        public Builder borderPadding(float padding) {
            this.mBorderPadding = padding;
            return this;
        }

        public Builder centerPadding(float padding) {
            this.mCenterPadding = padding;
            return this;
        }

        public Builder bgColor(int bgColor) {
            this.mBackgroundColor = bgColor;
            return this;
        }

        public Builder themeColor(int themeColor) {
            this.mThemeColor = themeColor;
            return this;
        }

        public Builder fadeColor(int fadeColor) {
            this.mFadeColor = fadeColor;
            return this;
        }

        public Builder petalCount(int petalCount) {
            this.mPetalCount = petalCount;
            return this;
        }

        public Builder petalThickness(int thickness) {
            this.mPetalThickness = thickness;
            return this;
        }

        public Builder petalAlpha(float alpha) {
            this.mPetalAlpha = alpha;
            return this;
        }

        public Builder bgCornerRadius(float cornerRadius) {
            this.mBackgroundCornerRadius = cornerRadius;
            return this;
        }

        public Builder bgAlpha(float alpha) {
            this.mBackgroundAlpha = alpha;
            return this;
        }

        public Builder direction(int direction) {
            this.mDirection = direction;
            return this;
        }

        public Builder speed(float speed) {
            this.mSpeed = speed;
            return this;
        }

        public Builder text(String text) {
            this.mText = text;
            return this;
        }

        public Builder textSize(int textSize) {
            this.mTextSize = textSize;
            return this;
        }

        public Builder textColor(int textColor) {
            this.mTextColor = textColor;
            return this;
        }

        public Builder textAlpha(float textAlpha) {
            this.mTextAlpha = textAlpha;
            return this;
        }

        public Builder textMarginTop(int textMarginTop) {
            this.mTextMarginTop = textMarginTop;
            return this;
        }

        public Builder isTextExpandWidth(boolean isTextExpandWidth) {
            this.mTextExpandWidth = isTextExpandWidth;
            return this;
        }

        public ACProgressFlower build() {
            return new ACProgressFlower(this);
        }
    }
}

