/*
 * Decompiled with CFR 0.152.
 */
package cc.cloudist.acplibrary;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.RectF;
import cc.cloudist.acplibrary.ACProgressBase;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

@SuppressLint(value={"ViewConstructor"})
public class ACProgressCustom
extends ACProgressBase {
    private List<Bitmap> mBitmaps;
    private RectF mRect = new RectF(0.0f, 0.0f, (float)this.mSize, (float)this.mSize);
    private float mSpeed;
    private int mImageCount = 0;
    private int mSpinCount = 0;
    private int mCurrentIndex = 0;

    public ACProgressCustom(Builder builder) {
        super(builder.mContext, builder.mSizeRatio);
        this.mBitmaps = new ArrayList<Bitmap>();
        this.mSpeed = builder.mSpeed;
        if (builder.mFilePaths.size() != 0) {
            this.mImageCount = builder.mFilePaths.size();
            for (int i = 0; i < this.mImageCount; ++i) {
                this.mBitmaps.add(BitmapFactory.decodeFile((String)((String)builder.mFilePaths.get(i))));
            }
        } else {
            this.mImageCount = builder.mResources.size();
            for (int i = 0; i < this.mImageCount; ++i) {
                this.mBitmaps.add(this.getBitmap(builder.mContext, (Integer)builder.mResources.get(i)));
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mSize, this.mSize);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawBitmap(this.mBitmaps.get(this.mCurrentIndex), null, this.mRect, null);
    }

    private Bitmap getBitmap(Context context, int resId) {
        InputStream is = context.getResources().openRawResource(resId);
        return BitmapFactory.decodeStream((InputStream)is);
    }

    @Override
    public void show() {
        ACProgressCustom.super.show();
        long delay = (long)(1000.0f / this.mSpeed);
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                int result = ACProgressCustom.this.mSpinCount % ACProgressCustom.this.mImageCount;
                ACProgressCustom.this.mCurrentIndex = ACProgressCustom.this.mImageCount - 1 - result;
                ACProgressCustom.this.mHandler.sendEmptyMessage(0);
                if (result == 0) {
                    ACProgressCustom.this.mSpinCount = 1;
                } else {
                    ACProgressCustom.this.mSpinCount++;
                }
            }
        }, delay, delay);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mBitmaps != null) {
            this.mBitmaps.clear();
        }
        this.mBitmaps = null;
        this.mRect = null;
    }

    public static class Builder {
        private Context mContext;
        private float mSizeRatio = 0.2f;
        private List<Integer> mResources = new ArrayList<Integer>();
        private List<String> mFilePaths = new ArrayList<String>();
        private float mSpeed = 6.67f;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder sizeRatio(float ratio) {
            this.mSizeRatio = ratio;
            return this;
        }

        public Builder speed(float speed) {
            this.mSpeed = speed;
            return this;
        }

        public Builder useImages(int ... imageIds) {
            this.mFilePaths.clear();
            for (int id : imageIds) {
                this.mResources.add(id);
            }
            return this;
        }

        public Builder useFiles(String ... paths) {
            this.mResources.clear();
            for (String path : paths) {
                this.mFilePaths.add(path);
            }
            return this;
        }

        public ACProgressCustom build() {
            return new ACProgressCustom(this);
        }
    }
}

