/*
 * Decompiled with CFR 0.152.
 */
package cc.cloudist.acplibrary;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import cc.cloudist.acplibrary.ACProgressBase;
import java.util.Timer;
import java.util.TimerTask;

@SuppressLint(value={"ViewConstructor"})
public class ACProgressPie
extends ACProgressBase {
    private RectF mBackgroundRect;
    private RectF mPieRect;
    private Paint mBackgroundPaint;
    private Paint mRingPaint;
    private Paint mPiePaint;
    private float mBackgroundCornerRadius;
    private float mRingBorderPadding;
    private int mSpinCount = 0;
    private int mCurrentFocusIndex = 0;
    private int mSlides = 20;
    private float mSpeed;

    public ACProgressPie(Builder builder) {
        super(builder.mContext, builder.mSizeRatio);
        this.mBackgroundCornerRadius = builder.mBackgroundCornerRadius;
        this.mRingBorderPadding = builder.mRingBorderPadding;
        this.mSpeed = builder.mSpeed;
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setColor(builder.mBackgroundColor);
        this.mBackgroundPaint.setAlpha((int)(builder.mBackgroundAlpha * 255.0f));
        this.mRingPaint = new Paint();
        this.mRingPaint.setAntiAlias(true);
        this.mRingPaint.setStrokeWidth((float)builder.mRingThickness);
        this.mRingPaint.setColor(builder.mRingColor);
        this.mRingPaint.setAlpha((int)(builder.mRingAlpha * 255.0f));
        this.mRingPaint.setStyle(Paint.Style.STROKE);
        this.mPiePaint = new Paint();
        this.mPiePaint.setAntiAlias(true);
        this.mPiePaint.setColor(builder.mPieColor);
        this.mPiePaint.setAlpha((int)(builder.mPieAlpha * 255.0f));
        float piePaddingValue = (builder.mRingBorderPadding + builder.mPieRingDistance) * (float)this.mSize;
        this.mBackgroundRect = new RectF(0.0f, 0.0f, (float)this.mSize, (float)this.mSize);
        this.mPieRect = new RectF(0.0f + piePaddingValue / 2.0f, 0.0f + piePaddingValue / 2.0f, (float)this.mSize - piePaddingValue / 2.0f, (float)this.mSize - piePaddingValue / 2.0f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mSize, this.mSize);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawRoundRect(this.mBackgroundRect, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, this.mBackgroundPaint);
        canvas.drawCircle((float)(this.mSize / 2), (float)(this.mSize / 2), (float)this.mSize * (1.0f - this.mRingBorderPadding) / 2.0f, this.mRingPaint);
        canvas.drawArc(this.mPieRect, -90.0f, (float)(360.0 / (double)(this.mSlides - 1) * (double)this.mCurrentFocusIndex), true, this.mPiePaint);
    }

    @Override
    public void show() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ACProgressPie.super.show();
                long delay = (long)(1000.0f / ACProgressPie.this.mSpeed);
                Timer timer = new Timer();
                timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        ACProgressPie.this.mCurrentFocusIndex = ACProgressPie.this.mSpinCount % ACProgressPie.this.mSlides;
                        ACProgressPie.this.mHandler.sendEmptyMessage(0);
                        if (ACProgressPie.this.mCurrentFocusIndex == 0) {
                            ACProgressPie.this.mSpinCount = 1;
                        } else {
                            ACProgressPie.this.mSpinCount++;
                        }
                    }
                }, delay, delay);
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBackgroundRect = null;
        this.mPieRect = null;
        this.mBackgroundPaint = null;
        this.mRingPaint = null;
        this.mPiePaint = null;
    }

    public void showAndUpdate(int percentage) {
        this.mSlides = 100;
        if (this.mCurrentFocusIndex >= 0 && this.mCurrentFocusIndex < 100) {
            this.mCurrentFocusIndex = percentage;
        }
        this.invalidate();
    }

    public static class Builder {
        private Context mContext;
        private float mSizeRatio = 0.2f;
        private int mBackgroundColor = -16777216;
        private float mBackgroundAlpha = 0.5f;
        private float mBackgroundCornerRadius = 20.0f;
        private int mRingColor = -1;
        private float mRingAlpha = 0.9f;
        private float mRingBorderPadding = 0.2f;
        private int mRingThickness = 3;
        private int mPieColor = -1;
        private float mPieAlpha = 0.9f;
        private float mPieRingDistance = 0.08f;
        private float mSpeed = 6.67f;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder bgColor(int color) {
            this.mBackgroundColor = color;
            return this;
        }

        public Builder bgAlpha(float alpha) {
            this.mBackgroundAlpha = alpha;
            return this;
        }

        public Builder bgCornerRadius(float cornerRadius) {
            this.mBackgroundCornerRadius = cornerRadius;
            return this;
        }

        public Builder ringColor(int color) {
            this.mRingColor = color;
            return this;
        }

        public Builder ringAlpha(float alpha) {
            this.mRingAlpha = alpha;
            return this;
        }

        public Builder ringBorderPadding(float padding) {
            this.mRingBorderPadding = padding;
            return this;
        }

        public Builder ringThickness(int thickness) {
            this.mRingThickness = thickness;
            return this;
        }

        public Builder pieColor(int color) {
            this.mPieColor = color;
            return this;
        }

        public Builder pieAlpha(float alpha) {
            this.mPieAlpha = alpha;
            return this;
        }

        public Builder pieRingDistance(float distance) {
            this.mPieRingDistance = distance;
            return this;
        }

        public Builder speed(float speed) {
            this.mSpeed = speed;
            return this;
        }

        public Builder sizeRatio(float ratio) {
            this.mSizeRatio = ratio;
            return this;
        }

        public ACProgressPie build() {
            return new ACProgressPie(this);
        }
    }
}

