/*
 * Decompiled with CFR 0.152.
 */
package cc.cloudist.acplibrary;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import cc.cloudist.acplibrary.ACProgressBase;
import cc.cloudist.acplibrary.components.FlowerDataCalc;
import cc.cloudist.acplibrary.components.PetalCoordinate;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

@SuppressLint(value={"ViewConstructor"})
public class ACProgressFlower
extends ACProgressBase {
    private RectF mBackgroundRect;
    private Paint mBackgroundPaint;
    private Paint mPetalPaint;
    private float mBackgroundCornerRadius;
    private int mPetalCount;
    private List<PetalCoordinate> mPetalCoordinates;
    private int[] mPetalColors;
    private int mFocusPetalIndex = 0;
    private int mSpinCount = 0;
    private int mDirection;
    private float mSpeed;

    private ACProgressFlower(Builder builder) {
        super(builder.mContext, builder.mSizeRatio);
        this.mBackgroundCornerRadius = builder.mBackgroundCornerRadius;
        this.mPetalCount = builder.mPetalCount;
        this.mDirection = builder.mDirection;
        this.mSpeed = builder.mSpeed;
        this.mBackgroundRect = new RectF(0.0f, 0.0f, (float)this.mSize, (float)this.mSize);
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setColor(builder.mBackgroundColor);
        this.mBackgroundPaint.setAlpha((int)(builder.mBackgroundAlpha * 255.0f));
        this.mPetalPaint = new Paint();
        this.mPetalPaint.setAntiAlias(true);
        this.mPetalPaint.setStrokeWidth((float)builder.mPetalThickness);
        this.mPetalPaint.setStrokeCap(Paint.Cap.ROUND);
        FlowerDataCalc calc = new FlowerDataCalc(builder.mPetalCount);
        this.mPetalCoordinates = calc.getSegmentsCoordinates(this.mSize, (int)(builder.mBorderPadding * (float)this.mSize), (int)(builder.mCenterPadding * (float)this.mSize), builder.mPetalCount);
        this.mPetalColors = calc.getSegmentsColors(builder.mThemeColor, builder.mFadeColor, builder.mPetalCount, (int)(builder.mPetalAlpha * 255.0f));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mSize, this.mSize);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawRoundRect(this.mBackgroundRect, this.mBackgroundCornerRadius, this.mBackgroundCornerRadius, this.mBackgroundPaint);
        for (int i = 0; i < this.mPetalCoordinates.size(); ++i) {
            PetalCoordinate coordinate = this.mPetalCoordinates.get(i);
            int index = (this.mFocusPetalIndex + i) % this.mPetalCoordinates.size();
            this.mPetalPaint.setColor(this.mPetalColors[index]);
            canvas.drawLine((float)coordinate.getStartX(), (float)coordinate.getStartY(), (float)coordinate.getEndX(), (float)coordinate.getEndY(), this.mPetalPaint);
        }
    }

    @Override
    public void show() {
        super.show();
        long delay = (long)(1000.0f / this.mSpeed);
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                int result = ACProgressFlower.this.mSpinCount % ACProgressFlower.this.mPetalCount;
                if (ACProgressFlower.this.mDirection == 0) {
                    ACProgressFlower.this.mFocusPetalIndex = result;
                } else {
                    ACProgressFlower.this.mFocusPetalIndex = ACProgressFlower.this.mPetalCount - 1 - result;
                }
                ACProgressFlower.this.mHandler.sendEmptyMessage(0);
                if (result == 0) {
                    ACProgressFlower.this.mSpinCount = 1;
                } else {
                    ACProgressFlower.this.mSpinCount++;
                }
            }
        }, delay, delay);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBackgroundPaint = null;
        this.mPetalPaint = null;
        this.mBackgroundRect = null;
        if (this.mPetalCoordinates != null) {
            this.mPetalCoordinates.clear();
        }
        this.mPetalColors = null;
        this.mPetalCoordinates = null;
        this.mPetalColors = null;
    }

    public static class Builder {
        public static final int DIRECT_CLOCKWISE = 0;
        public static final int DIRECT_ANTI_CLOCKWISE = 1;
        private Context mContext;
        private int mPetalCount = 12;
        private float mSizeRatio = 0.25f;
        private int mThemeColor = -1;
        private int mFadeColor = -12303292;
        private int mBackgroundColor = -16777216;
        private float mPetalAlpha = 0.5f;
        private float mBackgroundAlpha = 0.5f;
        private int mDirection = 0;
        private float mSpeed = 9.0f;
        private float mBorderPadding = 0.55f;
        private float mCenterPadding = 0.27f;
        private int mPetalThickness = 9;
        private float mBackgroundCornerRadius = 20.0f;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder petalThickness(int thickness) {
            this.mPetalThickness = thickness;
            return this;
        }

        public Builder borderPadding(float padding) {
            this.mBorderPadding = padding;
            return this;
        }

        public Builder centerPadding(float padding) {
            this.mCenterPadding = padding;
            return this;
        }

        public Builder petalCount(int petalCount) {
            this.mPetalCount = petalCount;
            return this;
        }

        public Builder bgCornerRadius(float cornerRadius) {
            this.mBackgroundCornerRadius = cornerRadius;
            return this;
        }

        public Builder themeColor(int themeColor) {
            this.mThemeColor = themeColor;
            return this;
        }

        public Builder fadeColor(int fadeColor) {
            this.mFadeColor = fadeColor;
            return this;
        }

        public Builder bgColor(int bgColor) {
            this.mBackgroundColor = bgColor;
            return this;
        }

        public Builder petalAlpha(float alpha) {
            this.mPetalAlpha = alpha;
            return this;
        }

        public Builder bgAlpha(float alpha) {
            this.mBackgroundAlpha = alpha;
            return this;
        }

        public Builder direction(int direction) {
            this.mDirection = direction;
            return this;
        }

        public Builder speed(float speed) {
            this.mSpeed = speed;
            return this;
        }

        public Builder sizeRatio(float ratio) {
            this.mSizeRatio = ratio;
            return this;
        }

        public ACProgressFlower build() {
            return new ACProgressFlower(this);
        }
    }
}

