/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.view;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import me.kareluo.imaging.core.IMGImage;
import me.kareluo.imaging.core.IMGMode;
import me.kareluo.imaging.core.IMGPath;
import me.kareluo.imaging.core.IMGText;
import me.kareluo.imaging.core.anim.IMGHomingAnimator;
import me.kareluo.imaging.core.homing.IMGHoming;
import me.kareluo.imaging.core.sticker.IMGSticker;
import me.kareluo.imaging.core.sticker.IMGStickerPortrait;
import me.kareluo.imaging.view.IMGStickerTextView;

public class IMGView
extends FrameLayout
implements Runnable,
ScaleGestureDetector.OnScaleGestureListener,
ValueAnimator.AnimatorUpdateListener,
IMGStickerPortrait.Callback,
Animator.AnimatorListener {
    private static final String TAG = "IMGView";
    private IMGMode mPreMode = IMGMode.NONE;
    private IMGImage mImage = new IMGImage();
    private GestureDetector mGDetector;
    private ScaleGestureDetector mSGDetector;
    private IMGHomingAnimator mHomingAnimator;
    private Pen mPen = new Pen();
    private int mPointerCount = 0;
    private Paint mDoodlePaint = new Paint(1);
    private Paint mMosaicPaint = new Paint(1);
    private static final boolean DEBUG = true;

    public IMGView(Context context) {
        this(context, null, 0);
    }

    public IMGView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IMGView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mDoodlePaint.setStyle(Paint.Style.STROKE);
        this.mDoodlePaint.setStrokeWidth(20.0f);
        this.mDoodlePaint.setColor(-65536);
        this.mDoodlePaint.setPathEffect((PathEffect)new CornerPathEffect(20.0f));
        this.mDoodlePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mDoodlePaint.setStrokeJoin(Paint.Join.ROUND);
        this.mMosaicPaint.setStyle(Paint.Style.STROKE);
        this.mMosaicPaint.setStrokeWidth(72.0f);
        this.mMosaicPaint.setColor(-16777216);
        this.mMosaicPaint.setPathEffect((PathEffect)new CornerPathEffect(72.0f));
        this.mMosaicPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mMosaicPaint.setStrokeJoin(Paint.Join.ROUND);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.mPen.setMode(this.mImage.getMode());
        this.mGDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new MoveAdapter());
        this.mSGDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
    }

    public void setImageBitmap(Bitmap image) {
        this.mImage.setBitmap(image);
        this.invalidate();
    }

    public void setMode(IMGMode mode) {
        this.mPreMode = this.mImage.getMode();
        this.mImage.setMode(mode);
        this.mPen.setMode(mode);
        this.onHoming();
    }

    boolean isHoming() {
        return this.mHomingAnimator != null && this.mHomingAnimator.isRunning();
    }

    private void onHoming() {
        this.invalidate();
        this.stopHoming();
        this.startHoming(this.mImage.getStartHoming(this.getScrollX(), this.getScrollY()), this.mImage.getEndHoming(this.getScrollX(), this.getScrollY()));
    }

    private void startHoming(IMGHoming sHoming, IMGHoming eHoming) {
        if (this.mHomingAnimator == null) {
            this.mHomingAnimator = new IMGHomingAnimator();
            this.mHomingAnimator.addUpdateListener(this);
            this.mHomingAnimator.addListener(this);
        }
        this.mHomingAnimator.setHomingValues(sHoming, eHoming);
        this.mHomingAnimator.start();
    }

    private void stopHoming() {
        if (this.mHomingAnimator != null) {
            this.mHomingAnimator.cancel();
        }
    }

    public void doRotate() {
        if (!this.isHoming()) {
            this.mImage.rotate(-90);
            this.onHoming();
        }
    }

    public void resetClip() {
        this.mImage.resetClip();
        this.onHoming();
    }

    public void doClip() {
        this.mImage.clip(this.getScrollX(), this.getScrollY());
        this.setMode(this.mPreMode);
        this.onHoming();
    }

    public void cancelClip() {
        this.mImage.toBackupClip();
        this.setMode(this.mPreMode);
    }

    public void setPenColor(int color) {
        this.mPen.setColor(color);
    }

    public boolean isDoodleEmpty() {
        return this.mImage.isDoodleEmpty();
    }

    public void undoDoodle() {
        this.mImage.undoDoodle();
        this.invalidate();
    }

    public boolean isMosaicEmpty() {
        return this.mImage.isMosaicEmpty();
    }

    public void undoMosaic() {
        this.mImage.undoMosaic();
        this.invalidate();
    }

    public IMGMode getMode() {
        return this.mImage.getMode();
    }

    protected void onDraw(Canvas canvas) {
        this.onDrawImages(canvas);
    }

    private void onDrawImages(Canvas canvas) {
        canvas.save();
        RectF clipFrame = this.mImage.getClipFrame();
        canvas.rotate(this.mImage.getRotate(), clipFrame.centerX(), clipFrame.centerY());
        this.mImage.onDrawImage(canvas);
        if (!this.mImage.isMosaicEmpty() || this.mImage.getMode() == IMGMode.MOSAIC && !this.mPen.isEmpty()) {
            int count = this.mImage.onDrawMosaicsPath(canvas);
            if (this.mImage.getMode() == IMGMode.MOSAIC && !this.mPen.isEmpty()) {
                this.mDoodlePaint.setStrokeWidth(72.0f);
                canvas.save();
                RectF frame = this.mImage.getClipFrame();
                canvas.rotate(-this.mImage.getRotate(), frame.centerX(), frame.centerY());
                canvas.translate((float)this.getScrollX(), (float)this.getScrollY());
                canvas.drawPath(this.mPen.getPath(), this.mDoodlePaint);
                canvas.restore();
            }
            this.mImage.onDrawMosaic(canvas, count);
        }
        this.mImage.onDrawDoodles(canvas);
        if (this.mImage.getMode() == IMGMode.DOODLE && !this.mPen.isEmpty()) {
            this.mDoodlePaint.setColor(this.mPen.getColor());
            this.mDoodlePaint.setStrokeWidth(20.0f * this.mImage.getScale());
            canvas.save();
            RectF frame = this.mImage.getClipFrame();
            canvas.rotate(-this.mImage.getRotate(), frame.centerX(), frame.centerY());
            canvas.translate((float)this.getScrollX(), (float)this.getScrollY());
            canvas.drawPath(this.mPen.getPath(), this.mDoodlePaint);
            canvas.restore();
        }
        if (this.mImage.isFreezing()) {
            this.mImage.onDrawStickers(canvas);
        }
        this.mImage.onDrawShade(canvas);
        canvas.restore();
        if (!this.mImage.isFreezing()) {
            this.mImage.onDrawStickerClip(canvas);
            this.mImage.onDrawStickers(canvas);
        }
        if (this.mImage.getMode() == IMGMode.CLIP) {
            canvas.save();
            canvas.translate((float)this.getScrollX(), (float)this.getScrollY());
            this.mImage.onDrawClip(canvas, this.getScrollX(), this.getScrollY());
            canvas.restore();
        }
    }

    public Bitmap saveBitmap() {
        this.mImage.stickAll();
        float scale = 1.0f / this.mImage.getScale();
        RectF frame = new RectF(this.mImage.getClipFrame());
        Matrix m = new Matrix();
        m.setRotate(this.mImage.getRotate(), frame.centerX(), frame.centerY());
        m.mapRect(frame);
        m.setScale(scale, scale, frame.left, frame.top);
        m.mapRect(frame);
        Bitmap bitmap = Bitmap.createBitmap((int)Math.round(frame.width()), (int)Math.round(frame.height()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate(-frame.left, -frame.top);
        canvas.scale(scale, scale, frame.left, frame.top);
        this.onDrawImages(canvas);
        return bitmap;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.mImage.onWindowChanged(right - left, bottom - top);
        }
    }

    public <V extends View> void addStickerView(V stickerView, FrameLayout.LayoutParams params) {
        if (stickerView != null) {
            this.addView(stickerView, (ViewGroup.LayoutParams)params);
            ((IMGStickerPortrait)stickerView).registerCallback(this);
            this.mImage.addSticker((IMGSticker)stickerView);
        }
    }

    public void addStickerText(IMGText text) {
        IMGStickerTextView textView = new IMGStickerTextView(this.getContext());
        textView.setText(text);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        textView.setX(this.getScrollX());
        textView.setY(this.getScrollY());
        this.addStickerView(textView, layoutParams);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getActionMasked() == 0) {
            return this.onInterceptTouch(ev) || super.onInterceptTouchEvent(ev);
        }
        return super.onInterceptTouchEvent(ev);
    }

    boolean onInterceptTouch(MotionEvent event) {
        if (this.isHoming()) {
            this.stopHoming();
            return true;
        }
        return this.mImage.getMode() == IMGMode.CLIP;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.removeCallbacks(this);
                break;
            }
            case 1: 
            case 3: {
                this.postDelayed(this, 1200L);
            }
        }
        return this.onTouch(event);
    }

    boolean onTouch(MotionEvent event) {
        if (this.isHoming()) {
            return false;
        }
        this.mPointerCount = event.getPointerCount();
        boolean handled = this.mSGDetector.onTouchEvent(event);
        IMGMode mode = this.mImage.getMode();
        if (mode == IMGMode.NONE || mode == IMGMode.CLIP) {
            handled |= this.onTouchNONE(event);
        } else if (this.mPointerCount > 1) {
            this.onPathDone();
            handled |= this.onTouchNONE(event);
        } else {
            handled |= this.onTouchPath(event);
        }
        switch (event.getActionMasked()) {
            case 0: {
                this.mImage.onTouchDown(event.getX(), event.getY());
                break;
            }
            case 1: 
            case 3: {
                this.mImage.onTouchUp(this.getScrollX(), this.getScrollY());
                this.onHoming();
            }
        }
        return handled;
    }

    private boolean onTouchNONE(MotionEvent event) {
        return this.mGDetector.onTouchEvent(event);
    }

    private boolean onTouchPath(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                return this.onPathBegin(event);
            }
            case 2: {
                return this.onPathMove(event);
            }
            case 1: 
            case 3: {
                return this.mPen.isIdentity(event.getPointerId(0)) && this.onPathDone();
            }
        }
        return false;
    }

    private boolean onPathBegin(MotionEvent event) {
        this.mPen.reset(event.getX(), event.getY());
        this.mPen.setIdentity(event.getPointerId(0));
        return true;
    }

    private boolean onPathMove(MotionEvent event) {
        if (this.mPen.isIdentity(event.getPointerId(0))) {
            this.mPen.lineTo(event.getX(), event.getY());
            this.invalidate();
            return true;
        }
        return false;
    }

    private boolean onPathDone() {
        if (this.mPen.isEmpty()) {
            return false;
        }
        this.mImage.addPath(this.mPen.toPath(), this.getScrollX(), this.getScrollY());
        this.mPen.reset();
        this.invalidate();
        return true;
    }

    @Override
    public void run() {
        if (!this.onSteady()) {
            this.postDelayed(this, 500L);
        }
    }

    boolean onSteady() {
        Log.d((String)TAG, (String)("onSteady: isHoming=" + this.isHoming()));
        if (!this.isHoming()) {
            this.mImage.onSteady(this.getScrollX(), this.getScrollY());
            this.onHoming();
            return true;
        }
        return false;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this);
        this.mImage.release();
    }

    public boolean onScale(ScaleGestureDetector detector) {
        if (this.mPointerCount > 1) {
            this.mImage.onScale(detector.getScaleFactor(), (float)this.getScrollX() + detector.getFocusX(), (float)this.getScrollY() + detector.getFocusY());
            this.invalidate();
            return true;
        }
        return false;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        if (this.mPointerCount > 1) {
            this.mImage.onScaleBegin();
            return true;
        }
        return false;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        this.mImage.onScaleEnd();
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.mImage.onHoming(animation.getAnimatedFraction());
        this.toApplyHoming((IMGHoming)animation.getAnimatedValue());
    }

    private void toApplyHoming(IMGHoming homing) {
        this.mImage.setScale(homing.scale);
        this.mImage.setRotate(homing.rotate);
        if (!this.onScrollTo(Math.round(homing.x), Math.round(homing.y))) {
            this.invalidate();
        }
    }

    private boolean onScrollTo(int x, int y) {
        if (this.getScrollX() != x || this.getScrollY() != y) {
            this.scrollTo(x, y);
            return true;
        }
        return false;
    }

    @Override
    public <V extends View> void onDismiss(V stickerView) {
        this.mImage.onDismiss((IMGSticker)stickerView);
        this.invalidate();
    }

    @Override
    public <V extends View> void onShowing(V stickerView) {
        this.mImage.onShowing((IMGSticker)stickerView);
        this.invalidate();
    }

    @Override
    public <V extends View> boolean onRemove(V stickerView) {
        if (this.mImage != null) {
            this.mImage.onRemoveSticker((IMGSticker)stickerView);
        }
        ((IMGStickerPortrait)stickerView).unregisterCallback(this);
        ViewParent parent = stickerView.getParent();
        if (parent != null) {
            ((ViewGroup)parent).removeView(stickerView);
        }
        return true;
    }

    public void onAnimationStart(Animator animation) {
        Log.d((String)TAG, (String)"onAnimationStart");
        this.mImage.onHomingStart(this.mHomingAnimator.isRotate());
    }

    public void onAnimationEnd(Animator animation) {
        Log.d((String)TAG, (String)"onAnimationEnd");
        if (this.mImage.onHomingEnd(this.getScrollX(), this.getScrollY(), this.mHomingAnimator.isRotate())) {
            this.toApplyHoming(this.mImage.clip(this.getScrollX(), this.getScrollY()));
        }
    }

    public void onAnimationCancel(Animator animation) {
        Log.d((String)TAG, (String)"onAnimationCancel");
        this.mImage.onHomingCancel(this.mHomingAnimator.isRotate());
    }

    public void onAnimationRepeat(Animator animation) {
    }

    private boolean onScroll(float dx, float dy) {
        IMGHoming homing = this.mImage.onScroll(this.getScrollX(), this.getScrollY(), -dx, -dy);
        if (homing != null) {
            this.toApplyHoming(homing);
            return true;
        }
        return this.onScrollTo(this.getScrollX() + Math.round(dx), this.getScrollY() + Math.round(dy));
    }

    private static class Pen
    extends IMGPath {
        private int identity = Integer.MIN_VALUE;

        private Pen() {
        }

        void reset() {
            this.path.reset();
            this.identity = Integer.MIN_VALUE;
        }

        void reset(float x, float y) {
            this.path.reset();
            this.path.moveTo(x, y);
            this.identity = Integer.MIN_VALUE;
        }

        void setIdentity(int identity) {
            this.identity = identity;
        }

        boolean isIdentity(int identity) {
            return this.identity == identity;
        }

        void lineTo(float x, float y) {
            this.path.lineTo(x, y);
        }

        boolean isEmpty() {
            return this.path.isEmpty();
        }

        IMGPath toPath() {
            return new IMGPath(new Path(this.path), this.getMode(), this.getColor(), this.getWidth());
        }
    }

    private class MoveAdapter
    extends GestureDetector.SimpleOnGestureListener {
        private MoveAdapter() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return IMGView.this.onScroll(distanceX, distanceY);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return super.onFling(e1, e2, velocityX, velocityY);
        }
    }
}

