/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.view;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import me.kareluo.imaging.core.IMGText;
import me.kareluo.imaging.core.sticker.IMGStickerX;

public class IMGStickerXText
extends IMGStickerX {
    private IMGText mText;
    private StaticLayout mTextLayout;
    private TextPaint mTextPaint = new TextPaint(1);

    public IMGStickerXText(IMGText text) {
        this.mTextPaint.setTextSize(TypedValue.applyDimension((int)2, (float)22.0f, (DisplayMetrics)Resources.getSystem().getDisplayMetrics()));
        this.setText(text);
    }

    public void setText(IMGText text) {
        this.mText = text;
        this.mTextPaint.setColor(text.getColor());
        this.mTextLayout = new StaticLayout((CharSequence)text.getText(), this.mTextPaint, Math.round((float)Resources.getSystem().getDisplayMetrics().widthPixels * 0.8f), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        float width = 0.0f;
        for (int i = 0; i < this.mTextLayout.getLineCount(); ++i) {
            width = Math.max(width, this.mTextLayout.getLineWidth(i));
        }
        this.onMeasure(width, this.mTextLayout.getHeight());
    }

    @Override
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        canvas.translate(this.mFrame.left, this.mFrame.top);
        this.mTextLayout.draw(canvas);
        canvas.restore();
    }
}

