/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ImageView;
import me.kareluo.imaging.R;
import me.kareluo.imaging.core.sticker.IMGSticker;
import me.kareluo.imaging.core.sticker.IMGStickerAdjustHelper;
import me.kareluo.imaging.core.sticker.IMGStickerHelper;
import me.kareluo.imaging.core.sticker.IMGStickerMoveHelper;
import me.kareluo.imaging.core.sticker.IMGStickerPortrait;

public abstract class IMGStickerView
extends ViewGroup
implements IMGSticker,
View.OnClickListener {
    private static final String TAG = "IMGStickerView";
    private View mContentView;
    private float mScale = 1.0f;
    private int mDownShowing = 0;
    private IMGStickerMoveHelper mMoveHelper;
    private IMGStickerHelper<IMGStickerView> mStickerHelper;
    private ImageView mRemoveView;
    private ImageView mAdjustView;
    private float mMaxScaleValue = 4.0f;
    private Paint PAINT;
    private Matrix mMatrix = new Matrix();
    private RectF mFrame = new RectF();
    private Rect mTempFrame = new Rect();
    private static final float MAX_SCALE_VALUE = 4.0f;
    private static final int ANCHOR_SIZE = 48;
    private static final int ANCHOR_SIZE_HALF = 24;
    private static final float STROKE_WIDTH = 3.0f;

    public IMGStickerView(Context context) {
        this(context, null, 0);
    }

    public IMGStickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IMGStickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.PAINT = new Paint(1);
        this.PAINT.setColor(-1);
        this.PAINT.setStyle(Paint.Style.STROKE);
        this.PAINT.setStrokeWidth(3.0f);
        this.onInitialize(context);
    }

    public void onInitialize(Context context) {
        this.setBackgroundColor(0);
        this.mContentView = this.onCreateContentView(context);
        this.addView(this.mContentView, this.getContentLayoutParams());
        this.mRemoveView = new ImageView(context);
        this.mRemoveView.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mRemoveView.setImageResource(R.mipmap.image_ic_delete);
        this.addView((View)this.mRemoveView, this.getAnchorLayoutParams());
        this.mRemoveView.setOnClickListener((View.OnClickListener)this);
        this.mAdjustView = new ImageView(context);
        this.mAdjustView.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mAdjustView.setImageResource(R.mipmap.image_ic_adjust);
        this.addView((View)this.mAdjustView, this.getAnchorLayoutParams());
        new IMGStickerAdjustHelper(this, (View)this.mAdjustView);
        this.mStickerHelper = new IMGStickerHelper<IMGStickerView>(this);
        this.mMoveHelper = new IMGStickerMoveHelper((View)this);
    }

    public abstract View onCreateContentView(Context var1);

    @Override
    public float getScale() {
        return this.mScale;
    }

    @Override
    public void setScale(float scale) {
        this.mScale = scale;
        this.mContentView.setScaleX(this.mScale);
        this.mContentView.setScaleY(this.mScale);
        int pivotX = this.getLeft() + this.getRight() >> 1;
        int pivotY = this.getTop() + this.getBottom() >> 1;
        this.mFrame.set((float)pivotX, (float)pivotY, (float)pivotX, (float)pivotY);
        this.mFrame.inset((float)(-(this.mContentView.getMeasuredWidth() >> 1)), (float)(-(this.mContentView.getMeasuredHeight() >> 1)));
        this.mMatrix.setScale(this.mScale, this.mScale, this.mFrame.centerX(), this.mFrame.centerY());
        this.mMatrix.mapRect(this.mFrame);
        this.mFrame.round(this.mTempFrame);
        this.layout(this.mTempFrame.left, this.mTempFrame.top, this.mTempFrame.right, this.mTempFrame.bottom);
    }

    @Override
    public void addScale(float scale) {
        this.setScale(this.getScale() * scale);
    }

    private ViewGroup.LayoutParams getContentLayoutParams() {
        return new ViewGroup.LayoutParams(-2, -2);
    }

    private ViewGroup.LayoutParams getAnchorLayoutParams() {
        return new ViewGroup.LayoutParams(48, 48);
    }

    public void draw(Canvas canvas) {
        if (this.isShowing()) {
            canvas.drawRect(24.0f, 24.0f, (float)(this.getWidth() - 24), (float)(this.getHeight() - 24), this.PAINT);
        }
        super.draw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(widthMeasureSpec, heightMeasureSpec);
            maxWidth = Math.round(Math.max((float)maxWidth, (float)child.getMeasuredWidth() * child.getScaleX()));
            maxHeight = Math.round(Math.max((float)maxHeight, (float)child.getMeasuredHeight() * child.getScaleY()));
            childState = IMGStickerView.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
        }
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(IMGStickerView.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), IMGStickerView.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mFrame.set((float)left, (float)top, (float)right, (float)bottom);
        int count = this.getChildCount();
        if (count == 0) {
            return;
        }
        this.mRemoveView.layout(0, 0, this.mRemoveView.getMeasuredWidth(), this.mRemoveView.getMeasuredHeight());
        this.mAdjustView.layout(right - left - this.mAdjustView.getMeasuredWidth(), bottom - top - this.mAdjustView.getMeasuredHeight(), right - left, bottom - top);
        int centerX = right - left >> 1;
        int centerY = bottom - top >> 1;
        int hw = this.mContentView.getMeasuredWidth() >> 1;
        int hh = this.mContentView.getMeasuredHeight() >> 1;
        this.mContentView.layout(centerX - hw, centerY - hh, centerX + hw, centerY + hh);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        return this.isShowing() && super.drawChild(canvas, child, drawingTime);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isShowing() && ev.getAction() == 0) {
            this.mDownShowing = 0;
            this.show();
            return true;
        }
        return this.isShowing() && super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean handled = this.mMoveHelper.onTouch((View)this, event);
        switch (event.getActionMasked()) {
            case 0: {
                ++this.mDownShowing;
                break;
            }
            case 1: {
                if (this.mDownShowing <= 1 || event.getEventTime() - event.getDownTime() >= (long)ViewConfiguration.getTapTimeout()) break;
                this.onContentTap();
                return true;
            }
        }
        return handled | super.onTouchEvent(event);
    }

    public void onClick(View v) {
        if (v == this.mRemoveView) {
            this.onRemove();
        }
    }

    public void onRemove() {
        this.mStickerHelper.remove();
    }

    public void onContentTap() {
    }

    @Override
    public boolean show() {
        return this.mStickerHelper.show();
    }

    @Override
    public boolean remove() {
        return this.mStickerHelper.remove();
    }

    @Override
    public boolean dismiss() {
        return this.mStickerHelper.dismiss();
    }

    @Override
    public boolean isShowing() {
        return this.mStickerHelper.isShowing();
    }

    @Override
    public RectF getFrame() {
        return this.mStickerHelper.getFrame();
    }

    @Override
    public void onSticker(Canvas canvas) {
        canvas.translate(this.mContentView.getX(), this.mContentView.getY());
        this.mContentView.draw(canvas);
    }

    @Override
    public void registerCallback(IMGStickerPortrait.Callback callback) {
        this.mStickerHelper.registerCallback(callback);
    }

    @Override
    public void unregisterCallback(IMGStickerPortrait.Callback callback) {
        this.mStickerHelper.unregisterCallback(callback);
    }
}

