/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import me.kareluo.imaging.IMGTextEditDialog;
import me.kareluo.imaging.core.IMGText;
import me.kareluo.imaging.view.IMGStickerView;

public class IMGStickerTextView
extends IMGStickerView
implements IMGTextEditDialog.Callback {
    private static final String TAG = "IMGStickerTextView";
    private TextView mTextView;
    private IMGText mText;
    private IMGTextEditDialog mDialog;
    private static float mBaseTextSize = -1.0f;
    private static final int PADDING = 26;
    private static final float TEXT_SIZE_SP = 24.0f;

    public IMGStickerTextView(Context context) {
        this(context, null, 0);
    }

    public IMGStickerTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IMGStickerTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void onInitialize(Context context) {
        if (mBaseTextSize <= 0.0f) {
            mBaseTextSize = TypedValue.applyDimension((int)2, (float)24.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        super.onInitialize(context);
    }

    @Override
    public View onCreateContentView(Context context) {
        this.mTextView = new TextView(context);
        this.mTextView.setTextSize(mBaseTextSize);
        this.mTextView.setPadding(26, 26, 26, 26);
        this.mTextView.setTextColor(-1);
        return this.mTextView;
    }

    public void setText(IMGText text) {
        this.mText = text;
        if (this.mText != null && this.mTextView != null) {
            this.mTextView.setText((CharSequence)this.mText.getText());
            this.mTextView.setTextColor(this.mText.getColor());
        }
    }

    public IMGText getText() {
        return this.mText;
    }

    @Override
    public void onContentTap() {
        IMGTextEditDialog dialog = this.getDialog();
        dialog.setText(this.mText);
        dialog.show();
    }

    private IMGTextEditDialog getDialog() {
        if (this.mDialog == null) {
            this.mDialog = new IMGTextEditDialog(this.getContext(), this);
        }
        return this.mDialog;
    }

    @Override
    public void onText(IMGText text) {
        this.mText = text;
        if (this.mText != null && this.mTextView != null) {
            this.mTextView.setText((CharSequence)this.mText.getText());
            this.mTextView.setTextColor(this.mText.getColor());
        }
    }
}

