/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.view;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.RadioButton;
import me.kareluo.imaging.R;

public class IMGColorRadio
extends RadioButton
implements ValueAnimator.AnimatorUpdateListener {
    private static final String TAG = "IMGColorRadio";
    private int mColor = -1;
    private int mStrokeColor = -1;
    private float mRadiusRatio = 0.0f;
    private ValueAnimator mAnimator;
    private Paint mPaint = new Paint(1);
    private static final float RADIUS_BASE = 0.6f;
    private static final float RADIUS_RING = 0.9f;
    private static final float RADIUS_BALL = 0.72f;

    public IMGColorRadio(Context context) {
        this(context, null, 0);
    }

    public IMGColorRadio(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0);
    }

    public IMGColorRadio(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IMGColorRadio);
        this.mColor = a.getColor(R.styleable.IMGColorRadio_image_color, -1);
        this.mStrokeColor = a.getColor(R.styleable.IMGColorRadio_image_stroke_color, -1);
        a.recycle();
        this.setButtonDrawable(null);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStrokeWidth(5.0f);
    }

    private ValueAnimator getAnimator() {
        if (this.mAnimator == null) {
            this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            this.mAnimator.setDuration(200L);
            this.mAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        }
        return this.mAnimator;
    }

    public void setColor(int color) {
        this.mColor = color;
        this.mPaint.setColor(this.mColor);
    }

    public int getColor() {
        return this.mColor;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        float hw = (float)this.getWidth() / 2.0f;
        float hh = (float)this.getHeight() / 2.0f;
        float radius = Math.min(hw, hh);
        canvas.save();
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle(hw, hh, this.getBallRadius(radius), this.mPaint);
        this.mPaint.setColor(this.mStrokeColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle(hw, hh, this.getRingRadius(radius), this.mPaint);
        canvas.restore();
    }

    private float getBallRadius(float radius) {
        return radius * (0.120000005f * this.mRadiusRatio + 0.6f);
    }

    private float getRingRadius(float radius) {
        return radius * (0.29999995f * this.mRadiusRatio + 0.6f);
    }

    public void setChecked(boolean checked) {
        boolean isChanged = checked != this.isChecked();
        super.setChecked(checked);
        if (isChanged) {
            ValueAnimator animator = this.getAnimator();
            if (checked) {
                animator.start();
            } else {
                animator.reverse();
            }
        }
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.mRadiusRatio = ((Float)animation.getAnimatedValue()).floatValue();
        this.invalidate();
    }
}

