/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.gallery.model;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import me.kareluo.imaging.gallery.model.IMGImageViewModel;

public class IMGImageInfo
implements Parcelable {
    private long size;
    private int width;
    private int height;
    private boolean isOriginal;
    private boolean isEdited;
    private Uri uri;
    public static final Parcelable.Creator<IMGImageInfo> CREATOR = new Parcelable.Creator<IMGImageInfo>(){

        public IMGImageInfo createFromParcel(Parcel in) {
            return new IMGImageInfo(in);
        }

        public IMGImageInfo[] newArray(int size) {
            return new IMGImageInfo[size];
        }
    };

    protected IMGImageInfo(Parcel in) {
        this.size = in.readLong();
        this.width = in.readInt();
        this.height = in.readInt();
        this.isOriginal = in.readByte() != 0;
        this.isEdited = in.readByte() != 0;
        this.uri = (Uri)in.readParcelable(Uri.class.getClassLoader());
    }

    public IMGImageInfo(IMGImageViewModel model) {
        this.size = model.getSize();
        this.width = model.getWidth();
        this.height = model.getHeight();
        this.isOriginal = model.isOriginal();
        this.isEdited = false;
        this.uri = model.getUri();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public void setOriginal(boolean original) {
        this.isOriginal = original;
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    public void setEdited(boolean edited) {
        this.isEdited = edited;
    }

    public Uri getUri() {
        return this.uri;
    }

    public void setUri(Uri uri) {
        this.uri = uri;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.size);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeByte((byte)(this.isOriginal ? 1 : 0));
        dest.writeByte((byte)(this.isEdited ? 1 : 0));
        dest.writeParcelable((Parcelable)this.uri, flags);
    }
}

