/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.gallery.model;

import android.os.Parcel;
import android.os.Parcelable;

public class IMGChooseMode
implements Parcelable {
    private boolean isOriginal = false;
    private boolean isOriginalChangeable = true;
    private boolean isSingleChoose = false;
    private int maxChooseCount = 9;
    public static final Parcelable.Creator<IMGChooseMode> CREATOR = new Parcelable.Creator<IMGChooseMode>(){

        public IMGChooseMode createFromParcel(Parcel in) {
            return new IMGChooseMode(in);
        }

        public IMGChooseMode[] newArray(int size) {
            return new IMGChooseMode[size];
        }
    };

    public IMGChooseMode() {
    }

    protected IMGChooseMode(Parcel in) {
        this.isOriginal = in.readByte() != 0;
        this.isOriginalChangeable = in.readByte() != 0;
        this.isSingleChoose = in.readByte() != 0;
        this.maxChooseCount = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.isOriginal ? 1 : 0));
        dest.writeByte((byte)(this.isOriginalChangeable ? 1 : 0));
        dest.writeByte((byte)(this.isSingleChoose ? 1 : 0));
        dest.writeInt(this.maxChooseCount);
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public boolean isOriginalChangeable() {
        return this.isOriginalChangeable;
    }

    public boolean isSingleChoose() {
        return this.isSingleChoose;
    }

    public int getMaxChooseCount() {
        return this.maxChooseCount;
    }

    public static class Builder {
        IMGChooseMode mode = new IMGChooseMode();

        public Builder setOriginal(boolean original) {
            this.mode.isOriginal = original;
            return this;
        }

        public Builder setOriginalChangeable(boolean originalChangeable) {
            this.mode.isOriginalChangeable = originalChangeable;
            return this;
        }

        public Builder setSingleChoose(boolean single) {
            this.mode.isSingleChoose = single;
            if (single) {
                this.mode.maxChooseCount = 1;
            }
            return this;
        }

        public Builder setMaxChooseCount(int maxChooseCount) {
            this.mode.maxChooseCount = maxChooseCount;
            if (this.mode.isSingleChoose) {
                this.mode.maxChooseCount = Math.min(1, maxChooseCount);
            }
            return this;
        }

        public IMGChooseMode build() {
            return this.mode;
        }
    }
}

