/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.gallery;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.kareluo.imaging.gallery.model.IMGImageViewModel;

public class IMGScanner {
    private static final String[] SELECTION_ARGS = new String[]{"image/jpeg", "image/png", "image/webp"};
    private static final String SELECTION = String.format("%s=? or %s=? or %s=?", "mime_type", "mime_type", "mime_type");
    public static final String ALL_IMAGES = "\u6240\u6709\u56fe\u7247";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<IMGImageViewModel>> getImages14(Context context, int count, Callback callback) {
        LinkedHashMap<String, List<IMGImageViewModel>> images = new LinkedHashMap<String, List<IMGImageViewModel>>();
        ContentResolver contentResolver = context.getContentResolver();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try (Cursor cursor = null;){
            cursor = contentResolver.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_data", "_size"}, SELECTION, SELECTION_ARGS, "date_modified desc");
            ArrayList<IMGImageViewModel> allInfos = new ArrayList<IMGImageViewModel>();
            images.put(ALL_IMAGES, allInfos);
            if (cursor == null) {
                LinkedHashMap<String, List<IMGImageViewModel>> linkedHashMap = images;
                return linkedHashMap;
            }
            while (cursor.moveToNext()) {
                File file;
                long size = cursor.getLong(cursor.getColumnIndex("_size"));
                String path = cursor.getString(cursor.getColumnIndex("_data"));
                if (size == 0L || TextUtils.isEmpty((CharSequence)path) || !(file = new File(path)).exists()) continue;
                BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
                IMGImageViewModel model = new IMGImageViewModel(Uri.fromFile((File)file));
                model.setWidth(options.outWidth);
                model.setHeight(options.outHeight);
                model.setSize(size);
                File parentFile = file.getParentFile();
                if (parentFile == null || !parentFile.exists()) continue;
                String folderName = file.getParentFile().getName();
                List<IMGImageViewModel> infos = images.get(folderName);
                if (infos == null) {
                    infos = new ArrayList<IMGImageViewModel>();
                    images.put(folderName, infos);
                }
                infos.add(model);
                allInfos.add(model);
                if (callback == null || allInfos.size() < count) continue;
                callback.onImages(allInfos);
            }
            LinkedHashMap<String, List<IMGImageViewModel>> linkedHashMap = images;
            return linkedHashMap;
        }
    }

    public static interface Callback {
        public void onImages(List<IMGImageViewModel> var1);
    }
}

