/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.gallery;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.RadioButton;
import android.widget.TextView;
import com.facebook.drawee.view.SimpleDraweeView;
import java.util.ArrayList;
import java.util.List;
import me.kareluo.imaging.R;
import me.kareluo.imaging.widget.IMGViewHolderCallback;

public class IMGGalleryMenuWindow
extends PopupWindow {
    private Context mContext;
    private MenuAdapter mAdapter;
    private RecyclerView mMenuRecyclerView;
    private List<GalleryMenuItemViewModel> mItemModels;
    private LayoutInflater mLayoutInflater;

    public IMGGalleryMenuWindow(Context context) {
        super(context);
        this.mContext = context;
        View contentView = this.getLayoutInflater().inflate(R.layout.image_layout_gallery_pop, null, false);
        this.setContentView(contentView);
        this.setWidth(-1);
        DisplayMetrics metrics = this.mContext.getResources().getDisplayMetrics();
        this.setHeight(Math.round((float)metrics.heightPixels * 0.76f));
        this.setOutsideTouchable(true);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0x60000000));
        this.mAdapter = new MenuAdapter();
        this.mMenuRecyclerView = (RecyclerView)contentView.findViewById(R.id.image_rv_menu);
        this.mMenuRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    private LayoutInflater getLayoutInflater() {
        if (this.mLayoutInflater == null) {
            this.mLayoutInflater = LayoutInflater.from((Context)this.mContext);
        }
        return this.mLayoutInflater;
    }

    public void setMenuItems(List<String> menuItems) {
        if (menuItems != null) {
            if (this.mItemModels == null) {
                this.mItemModels = new ArrayList<GalleryMenuItemViewModel>();
            }
            this.mItemModels.clear();
            GalleryMenuItemViewModel _all = null;
            for (String item : menuItems) {
                GalleryMenuItemViewModel model = new GalleryMenuItemViewModel(null, item, "\u6240\u6709\u56fe\u7247".equals(item));
                if ("\u6240\u6709\u56fe\u7247".equals(item)) {
                    _all = model;
                }
                this.mItemModels.add(model);
            }
            this.ensureSingleItemSelected(_all);
        }
    }

    private void ensureSingleItemSelected(GalleryMenuItemViewModel model) {
        if (this.mItemModels != null) {
            for (GalleryMenuItemViewModel m : this.mItemModels) {
                m.isSelected = m == model;
            }
        }
    }

    private void onItemSelected(int position) {
        GalleryMenuItemViewModel item = this.mAdapter.getItem(position);
        if (item != null) {
            this.ensureSingleItemSelected(item);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void show(View parent) {
        this.showAsDropDown(parent, 0, 0);
    }

    public static class GalleryMenuItemViewModel {
        private Uri uri;
        private String name;
        private boolean isSelected;

        public GalleryMenuItemViewModel(Uri uri, String name, boolean isSelected) {
            this.uri = uri;
            this.name = name;
            this.isSelected = isSelected;
        }
    }

    private static class MenuItemViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private SimpleDraweeView imageView;
        private TextView textView;
        private RadioButton radioButton;
        private IMGViewHolderCallback callback;

        public MenuItemViewHolder(View itemView, IMGViewHolderCallback callback) {
            super(itemView);
            this.callback = callback;
            this.imageView = (SimpleDraweeView)itemView.findViewById(R.id.sdv_image);
            this.textView = (TextView)itemView.findViewById(R.id.tv_name);
            this.radioButton = (RadioButton)itemView.findViewById(R.id.rb_select);
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        public void update(GalleryMenuItemViewModel model) {
            this.textView.setText((CharSequence)model.name);
            this.radioButton.setChecked(model.isSelected);
        }

        public void onClick(View v) {
            if (this.callback != null) {
                this.callback.onViewHolderClick(this);
            }
        }
    }

    private class MenuAdapter
    extends RecyclerView.Adapter<MenuItemViewHolder>
    implements IMGViewHolderCallback {
        private MenuAdapter() {
        }

        public MenuItemViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new MenuItemViewHolder(IMGGalleryMenuWindow.this.getLayoutInflater().inflate(R.layout.image_layout_gallery_menu_item, parent, false), this);
        }

        public void onBindViewHolder(MenuItemViewHolder holder, int position) {
            holder.update(this.getItem(position));
        }

        public GalleryMenuItemViewModel getItem(int position) {
            if (position >= 0 && position < this.getItemCount()) {
                return (GalleryMenuItemViewModel)IMGGalleryMenuWindow.this.mItemModels.get(position);
            }
            return null;
        }

        public int getItemCount() {
            return IMGGalleryMenuWindow.this.mItemModels == null ? 0 : IMGGalleryMenuWindow.this.mItemModels.size();
        }

        @Override
        public void onViewHolderClick(RecyclerView.ViewHolder holder) {
            IMGGalleryMenuWindow.this.onItemSelected(holder.getAdapterPosition());
        }
    }
}

