/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.core.sticker;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.MotionEvent;

public class IMGStickerX {
    private float mBaseScale = 1.0f;
    private float mScale = 1.0f;
    private float mBaseRotate = 0.0f;
    private float mRotate = 0.0f;
    private float mX = 0.0f;
    private float mY = 0.0f;
    protected float[] mPivotXY = new float[]{0.0f, 0.0f};
    private StickerEvent mTouchEvent;
    private boolean isActivated = true;
    protected RectF mFrame = new RectF();
    private RectF mRemoveFrame = new RectF();
    private RectF mAdjustFrame = new RectF();
    private static final float SIZE_ANCHOR = 60.0f;
    private static final float STROKE_FRAME = 6.0f;
    private Paint mPaint = new Paint(1);

    public IMGStickerX() {
        this.mPaint.setColor(-65536);
        this.mPaint.setStrokeWidth(6.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mFrame.set(0.0f, 0.0f, 120.0f, 120.0f);
        this.mRemoveFrame.set(0.0f, 0.0f, 60.0f, 60.0f);
        this.mAdjustFrame.set(0.0f, 0.0f, 60.0f, 60.0f);
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public void setActivated(boolean activated) {
        this.isActivated = activated;
    }

    public void onMeasure(float width, float height) {
        this.mFrame.set(0.0f, 0.0f, width, height);
        this.mFrame.offset(this.mPivotXY[0] - this.mFrame.centerX(), this.mPivotXY[1] - this.mFrame.centerY());
    }

    public void onDraw(Canvas canvas) {
        if (this.isActivated) {
            canvas.save();
            canvas.rotate(this.mRotate, this.mPivotXY[0], this.mPivotXY[1]);
            canvas.drawRect(this.mFrame, this.mPaint);
            canvas.translate(this.mFrame.left, this.mFrame.top);
            canvas.drawRect(this.mRemoveFrame, this.mPaint);
            canvas.translate(this.mFrame.width() - this.mAdjustFrame.width(), this.mFrame.height() - this.mAdjustFrame.height());
            canvas.drawRect(this.mAdjustFrame, this.mPaint);
            canvas.restore();
        }
        canvas.rotate(this.mRotate, this.mPivotXY[0], this.mPivotXY[1]);
    }

    public void setScale(float scale) {
        this.mScale = scale;
    }

    public void setRotate(float rotate) {
        this.mRotate = rotate;
    }

    public void setBaseScale(float baseScale) {
        this.mBaseScale = baseScale;
    }

    public void setBaseRotate(float baseRotate) {
        this.mBaseRotate = baseRotate;
    }

    public void offset(float dx, float dy) {
        this.mPivotXY[0] = this.mPivotXY[0] + dx;
        this.mPivotXY[1] = this.mPivotXY[1] + dy;
        this.mFrame.offset(this.mPivotXY[0] - this.mFrame.centerX(), this.mPivotXY[1] - this.mFrame.centerY());
    }

    public StickerEvent onTouch(MotionEvent event) {
        int action = event.getActionMasked();
        if (this.mTouchEvent == null && action != 0) {
            return null;
        }
        switch (action) {
            case 0: {
                this.mX = event.getX();
                this.mY = event.getY();
                this.mTouchEvent = this.getTouchEvent(this.mX, this.mY);
                return this.mTouchEvent;
            }
            case 2: {
                if (this.mTouchEvent != StickerEvent.BODY) break;
                this.offset(event.getX() - this.mX, event.getY() - this.mY);
                this.mX = event.getX();
                this.mY = event.getY();
            }
        }
        return this.mTouchEvent;
    }

    private StickerEvent getTouchEvent(float x, float y) {
        float[] xy = new float[]{x, y};
        Matrix matrix = new Matrix();
        matrix.setRotate(this.mRotate, this.mFrame.centerX(), this.mFrame.centerY());
        matrix.mapPoints(xy);
        if (this.mFrame.contains(xy[0], xy[1])) {
            if (this.isInsideRemove(xy[0], xy[1])) {
                this.mTouchEvent = StickerEvent.REMOVE;
                return this.mTouchEvent;
            }
            if (this.isInsideAdjust(xy[0], xy[1])) {
                this.mTouchEvent = StickerEvent.ADJUST;
                return this.mTouchEvent;
            }
            return StickerEvent.BODY;
        }
        return null;
    }

    public void setTouchEvent(StickerEvent touchEvent) {
        this.mTouchEvent = touchEvent;
    }

    public boolean isInsideRemove(float x, float y) {
        return this.mRemoveFrame.contains(x - this.mFrame.left, y - this.mFrame.top);
    }

    public boolean isInsideAdjust(float x, float y) {
        return this.mAdjustFrame.contains(x - this.mFrame.right + this.mAdjustFrame.width(), y - this.mFrame.bottom + this.mAdjustFrame.height());
    }

    public boolean isInside(float x, float y) {
        float[] xy = new float[]{x, y};
        Matrix matrix = new Matrix();
        matrix.setRotate(this.mRotate, this.mFrame.centerX(), this.mFrame.centerY());
        matrix.mapPoints(xy);
        return this.mFrame.contains(xy[0], xy[1]);
    }

    public void transform(Matrix matrix) {
        matrix.mapPoints(this.mPivotXY);
        this.mFrame.offset(this.mPivotXY[0] - this.mFrame.centerX(), this.mPivotXY[1] - this.mFrame.centerY());
    }

    public static enum StickerEvent {
        REMOVE,
        BODY,
        ADJUST;

    }
}

